package com.saygoer.gradle

import com.saygoer.gradle.tasks.ActiveProfileTask
import com.saygoer.gradle.tasks.CombineExtJsTask
import com.saygoer.gradle.tasks.CombineFileTask
import com.saygoer.gradle.tasks.SQLTask
import org.gradle.api.Plugin
import org.gradle.api.Project

class AppPlugin implements Plugin<Project> {

    @Override
    void apply(Project project) {
        def taskGroup = 'app'

        //combine
        project.task('combine', type: CombineFileTask, group: 'build', description: 'Combine many JavaScript files into one') {}
        project.task('combineExtJs', type: CombineExtJsTask, group: taskGroup, description: 'Combine many EXTJS JavaScript files into one') {}

        //active
        project.task('activeProfile', type: ActiveProfileTask, group: 'build', description: 'spring profile ') {}
        project.task('activeAlpha', group: taskGroup, description: 'spring profile alpha ') {
            doLast { project.activeProfile.profile 'alpha'; ActiveProfileTask.activeProfile(project) }
        }
        project.task('activeBeta', group: taskGroup, description: 'spring profile beta ') {
            doLast { project.activeProfile.profile 'beta'; ActiveProfileTask.activeProfile(project) }
        }
        project.task('activeRelease', group: taskGroup, description: 'spring profile release ') {
            doLast { project.activeProfile.profile 'release'; ActiveProfileTask.activeProfile(project) }
        }

        //jar
        project.task('jarAlpha', dependsOn: [project.activeAlpha, project.jar], group: taskGroup, description: '') {}
        project.task('jarBeta', dependsOn: [project.activeBeta, project.jar], group: taskGroup, description: '') {
            doLast { project.activeAlpha.execute() }
        }
        project.task('jarRelease', dependsOn: [project.activeRelease, project.jar], group: taskGroup, description: '') {
            doLast { project.activeAlpha.execute() }
        }

        project.jar.mustRunAfter project.activeAlpha, project.activeBeta, project.activeRelease

        //war
        project.task('warAlpha', dependsOn: [project.activeAlpha, project.war], group: taskGroup, description: '') {
        }
        project.task('warBeta', dependsOn: [project.activeBeta, project.war], group: taskGroup, description: '') {
            doLast { project.activeAlpha.execute() }
        }
        project.task('warRelease', dependsOn: [project.activeRelease, project.war], group: taskGroup, description: '') {
            doLast { project.activeAlpha.execute() }
        }

        project.war.mustRunAfter project.activeAlpha, project.activeBeta, project.activeRelease

        //run
        try {
            project.task('bootRunAlpha', dependsOn: [project.activeAlpha, project.bootRun], group: taskGroup, description: '')
            project.bootRun.mustRunAfter project.activeAlpha
        } catch (ignored) {
        }

        //sql
        project.task('sql', type: SQLTask, group: 'build', description: '') {}
    }
}