/*
 * Decompiled with CFR 0.152.
 */
package com.sayweee.spock.mockfree.extension;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.sayweee.spock.mockfree.annotation.MockStatic;
import com.sayweee.spock.mockfree.transformer.MockfreeTransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;

@AutoService(value={IGlobalExtension.class})
public class GlobalExtension
implements IGlobalExtension {
    private static final Logger log = LoggerFactory.getLogger(GlobalExtension.class);
    private static final MockfreeTransformer mockfreeTransformer = MockfreeTransformer.getInstance();
    private final HashMap<String, Map<Class<?>, Set<Method>>> staticMethodsSpecMap = new HashMap();

    public void visitSpec(SpecInfo spec) {
        final String specClassName = spec.getPackage() + "." + spec.getName();
        this.buildStaticMethods(spec, specClassName);
        if (this.staticMethodsSpecMap.get(specClassName) == null) {
            return;
        }
        spec.addSetupSpecInterceptor((IMethodInterceptor)new AbstractMethodInterceptor(){

            public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
                Map methodsMap = (Map)GlobalExtension.this.staticMethodsSpecMap.get(specClassName);
                if (methodsMap != null) {
                    Set targetClasses = methodsMap.keySet();
                    for (Class targetClass : targetClasses) {
                        mockfreeTransformer.mockStaticMethod((Set)methodsMap.get(targetClass), targetClass, Class.forName(specClassName));
                    }
                }
                invocation.proceed();
            }
        });
        spec.addCleanupSpecInterceptor((IMethodInterceptor)new AbstractMethodInterceptor(){

            public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
                Map methodsMap = (Map)GlobalExtension.this.staticMethodsSpecMap.get(specClassName);
                if (methodsMap != null) {
                    mockfreeTransformer.recoveryClasses((Class[])Iterables.toArray(methodsMap.keySet(), Class.class));
                }
                invocation.proceed();
            }
        });
    }

    private void buildStaticMethods(SpecInfo spec, String specClassName) {
        Method[] declaredMethods = ((Class)spec.getReflection()).getDeclaredMethods();
        HashMap methodsMap = new HashMap();
        for (Method declaredMethod : declaredMethods) {
            if (!Modifier.isStatic(declaredMethod.getModifiers()) || !declaredMethod.isAnnotationPresent(MockStatic.class)) continue;
            MockStatic annotation = declaredMethod.getAnnotation(MockStatic.class);
            Class<?> targetClass = annotation.value();
            if (targetClass != Void.TYPE) {
                HashSet<Method> methodSet = (HashSet<Method>)methodsMap.get(targetClass);
                if (methodSet == null) {
                    methodSet = new HashSet<Method>();
                }
                methodSet.add(declaredMethod);
                methodsMap.put(targetClass, methodSet);
                continue;
            }
            log.info("specClassName:{} use @MockStatic but lost targetClass value", (Object)specClassName);
        }
        this.staticMethodsSpecMap.put(specClassName, methodsMap);
    }
}

