/*
 * Decompiled with CFR 0.152.
 */
package com.sayweee.spock.mockfree.transformer;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.extension.ExtensionException;

public class MockfreeTransformer {
    public static final String CLASS_NAME = "MockFreeTargetClasses";
    public static final String PACKAGE_PATH = "com.sayweee.spock.mockfree";
    public static final String TARGET_CLASSES = "targetClasses";
    private static final Logger log = LoggerFactory.getLogger(MockfreeTransformer.class);
    private static Instrumentation instrumentation;
    private static MockfreeTransformer instance;

    public static synchronized MockfreeTransformer getInstance() {
        if (instance == null) {
            instance = new MockfreeTransformer();
        }
        return instance;
    }

    private MockfreeTransformer() {
        log.info("Activating @MockFree transformation");
        instrumentation = ByteBuddyAgent.install();
        MockfreeTransformer.installTransformer();
    }

    private static void installTransformer() {
        try {
            Class<?> clazz = Class.forName("com.sayweee.spock.mockfree.MockFreeTargetClasses");
            Field declaredField = clazz.getDeclaredField(TARGET_CLASSES);
            MockfreeTransformer.buildAndInstallTransformer((String)declaredField.get(null));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.warn("installTransformer error {}", (Object)e.getMessage());
        }
    }

    private static void buildAndInstallTransformer(String classesString) {
        new AgentBuilder.Default(new ByteBuddy().with(TypeValidation.DISABLED)).ignore((ElementMatcher)ElementMatchers.none()).with((AgentBuilder.InstallationListener)new InstallationListener()).with((AgentBuilder.Listener)new DiscoveryListener()).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).type(typeDescription -> MockfreeTransformer.isTransformable(classesString, typeDescription)).transform(MockfreeTransformer::transform).installOn(instrumentation);
    }

    private static boolean isTransformable(String classesString, TypeDescription typeDescription) {
        return MockfreeTransformer.isInClasses(classesString, typeDescription);
    }

    private static boolean isInClasses(String classesString, TypeDescription typeDescription) {
        if (classesString.isEmpty()) {
            return false;
        }
        return Arrays.stream(classesString.split(",")).anyMatch(s -> typeDescription.getName().equals(s));
    }

    public void mockStaticMethod(Set<Method> methodsSet, Class<?> targetClass, Class<?> specClass) {
        DynamicType.Builder builder = new ByteBuddy().redefine(targetClass);
        for (Method method : methodsSet) {
            builder = builder.method((ElementMatcher)ElementMatchers.named((String)method.getName()).and((ElementMatcher)ElementMatchers.takesArguments((Class[])method.getParameterTypes()))).intercept((Implementation)MethodDelegation.to(specClass));
        }
        builder.make().load(targetClass.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    public void recoveryClasses(Class<?>[] mockFreeClasses) throws IOException {
        for (Class<?> targetClass : mockFreeClasses) {
            ClassReloadingStrategy.of((Instrumentation)instrumentation).reset(new Class[]{targetClass});
        }
    }

    private static DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDefinitions, ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        return builder.visit((AsmVisitorWrapper)new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isPrivate(), new ModifierContributor.ForMethod[]{Visibility.PUBLIC})).visit((AsmVisitorWrapper)new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForMethod[]{MethodManifestation.PLAIN})).visit((AsmVisitorWrapper)new ModifierAdjustment().withFieldModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForField[]{FieldManifestation.PLAIN})).visit((AsmVisitorWrapper)new ModifierAdjustment().withTypeModifiers((ElementMatcher)ElementMatchers.isFinal(), new ModifierContributor.ForType[]{TypeManifestation.PLAIN}));
    }

    private static class DiscoveryListener
    extends AgentBuilder.Listener.Adapter {
        private DiscoveryListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            log.warn("Could not transform class '{}', loaded: {}", new Object[]{typeName, loaded, throwable});
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            log.trace("Processed class '{}', loaded: {}", (Object)typeName, (Object)loaded);
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            log.trace("Processing class '{}', loaded: {}", (Object)typeName, (Object)loaded);
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            log.debug("Transforming class '{}', loaded: {}", (Object)typeDescription, (Object)loaded);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
            log.trace("Ignoring class '{}', loaded: {}", (Object)typeDescription, (Object)loaded);
        }
    }

    private static class InstallationListener
    extends AgentBuilder.InstallationListener.Adapter {
        private InstallationListener() {
        }

        public Throwable onError(Instrumentation instrumentation, ResettableClassFileTransformer classFileTransformer, Throwable throwable) {
            throw new ExtensionException("Unable install mockfree transformation", throwable);
        }
    }
}

