/*
 * Decompiled with CFR 0.152.
 */
package com.scalableminds.bloscjava;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Blosc {
    private Blosc() {
    }

    public static byte[] compress(byte[] src, int typeSize, Compressor compressor, int compressorLevel, Shuffle shuffle, int blockSize, int numThreads) {
        if (typeSize < 1) {
            throw new IllegalArgumentException("Argument typeSize needs to be larger than 0.");
        }
        return Blosc._compress(src, typeSize, compressorLevel, shuffle.shuffle, blockSize, compressor.compressor, numThreads);
    }

    public static byte[] compress(byte[] src, int typeSize, Compressor compressor, int compressorLevel, Shuffle shuffle, int blockSize) {
        return Blosc.compress(src, typeSize, compressor, compressorLevel, shuffle, blockSize, 1);
    }

    public static byte[] compress(byte[] src, int typeSize, Compressor compressor, int compressorLevel, Shuffle shuffle) {
        return Blosc.compress(src, typeSize, compressor, compressorLevel, shuffle, 0);
    }

    public static byte[] compress(byte[] src, int typeSize, Compressor compressor, int compressorLevel) {
        return Blosc.compress(src, typeSize, compressor, compressorLevel, typeSize == 1 ? Shuffle.BIT_SHUFFLE : Shuffle.BYTE_SHUFFLE);
    }

    public static byte[] compress(byte[] src, int typeSize, Compressor compressor) {
        return Blosc.compress(src, typeSize, compressor, 5);
    }

    public static byte[] compress(byte[] src, int typeSize) {
        return Blosc.compress(src, typeSize, Compressor.ZSTD);
    }

    public static byte[] decompress(byte[] src, int numThreads) {
        return Blosc._decompress(src, numThreads);
    }

    public static byte[] decompress(byte[] src) {
        return Blosc.decompress(src, 1);
    }

    private static native byte[] _compress(byte[] var0, int var1, int var2, int var3, int var4, String var5, int var6);

    private static native byte[] _decompress(byte[] var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File loadLibraryFromJarToTemp() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        String filePrefix = "libbloscjni";
        try (InputStream is = null;){
            String extension = ".so";
            if (os.contains("mac")) {
                extension = ".dylib";
            }
            if (os.contains("win")) {
                extension = ".dll";
            }
            String libraryFileName = "libbloscjni" + extension;
            is = Blosc.class.getClassLoader().getResourceAsStream(libraryFileName);
            if (is == null) {
                throw new RuntimeException(libraryFileName + " was not found inside JAR.");
            }
            File temp = File.createTempFile("libbloscjni", extension);
            if (!temp.exists()) {
                throw new RuntimeException("File " + temp.getAbsolutePath() + " does not exist.");
            }
            temp.deleteOnExit();
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file = temp;
            return file;
        }
    }

    static {
        try {
            System.load(Blosc.loadLibraryFromJarToTemp().getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load libbloscjni.");
        }
    }

    public static enum Shuffle {
        NO_SHUFFLE(0, "noshuffle"),
        BYTE_SHUFFLE(1, "byteshuffle"),
        BIT_SHUFFLE(2, "bitshuffle");

        private final int shuffle;
        private final String shuffleString;

        private Shuffle(int shuffle, String shuffleString) {
            this.shuffle = shuffle;
            this.shuffleString = shuffleString;
        }

        public static Shuffle fromInt(int shuffle) {
            for (Shuffle e : Shuffle.values()) {
                if (e.shuffle != shuffle) continue;
                return e;
            }
            return null;
        }

        public static Shuffle fromString(String shuffle) {
            for (Shuffle e : Shuffle.values()) {
                if (!e.shuffleString.equalsIgnoreCase(shuffle)) continue;
                return e;
            }
            return null;
        }

        public int getValue() {
            return this.shuffle;
        }
    }

    public static enum Compressor {
        LZ4("lz4"),
        LZ4HC("lz4hc"),
        BLOSCLZ("blosclz"),
        ZSTD("zstd"),
        ZLIB("zlib");

        private final String compressor;

        private Compressor(String compressor) {
            this.compressor = compressor;
        }

        public static Compressor fromString(String compressor) {
            for (Compressor e : Compressor.values()) {
                if (!e.compressor.equalsIgnoreCase(compressor)) continue;
                return e;
            }
            return null;
        }

        public String getValue() {
            return this.compressor;
        }
    }
}

