/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.ClientCredentials;
import com.scalepoint.oauth_token_client.ExpiringToken;
import com.scalepoint.oauth_token_client.NameValuePair;
import com.scalepoint.oauth_token_client.StringUtil;
import com.scalepoint.oauth_token_client.TokenCache;
import com.scalepoint.oauth_token_client.TokenEndpointHttpClient;
import com.scalepoint.oauth_token_client.TokenSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CustomGrantTokenClient {
    private final ClientCredentials clientCredentials;
    private final TokenEndpointHttpClient tokenEndpointHttpClient;
    private final String partialCacheKey;
    private final TokenCache cache;

    public CustomGrantTokenClient(String tokenEndpointUri, ClientCredentials clientCredentials, TokenCache cache) {
        this.tokenEndpointHttpClient = new TokenEndpointHttpClient(tokenEndpointUri);
        this.clientCredentials = clientCredentials;
        this.partialCacheKey = StringUtil.join(new String[]{tokenEndpointUri, clientCredentials.getCredentialThumbprint()}, ":");
        this.cache = cache;
    }

    protected String getTokenInternal(final List<NameValuePair> parameters, String ... scopes) throws IOException {
        final String scopeString = scopes == null || scopes.length < 1 ? null : StringUtil.join(scopes, " ");
        String cacheKey = StringUtil.join(new String[]{this.partialCacheKey, this.getGrantType(), scopeString, String.valueOf(parameters.hashCode())}, ":");
        return this.cache.get(cacheKey, new TokenSource(){

            @Override
            public ExpiringToken get() throws IOException {
                ArrayList<NameValuePair> form = new ArrayList<NameValuePair>();
                form.add(new NameValuePair("grant_type", CustomGrantTokenClient.this.getGrantType()));
                form.addAll(CustomGrantTokenClient.this.clientCredentials.getPostParams());
                form.addAll(parameters);
                if (scopeString != null) {
                    form.add(new NameValuePair("scope", scopeString));
                }
                return CustomGrantTokenClient.this.tokenEndpointHttpClient.getToken(form);
            }
        });
    }

    protected abstract String getGrantType();
}

