/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.CertificateUtil;
import com.scalepoint.oauth_token_client.CertificateWithPrivateKey;
import com.scalepoint.oauth_token_client.ClientAssertionJwtFactory;
import com.scalepoint.oauth_token_client.ClientCredentials;
import com.scalepoint.oauth_token_client.DigestUtil;
import com.scalepoint.oauth_token_client.NameValuePair;
import java.util.ArrayList;
import java.util.List;

public class JwtBearerClientAssertionCredentials
implements ClientCredentials {
    private final String credentialThumbprint;
    private final ClientAssertionJwtFactory assertionFactory;

    public JwtBearerClientAssertionCredentials(String tokenEndpointUri, String clientId, CertificateWithPrivateKey keyPair) {
        this.assertionFactory = new ClientAssertionJwtFactory(tokenEndpointUri, clientId, keyPair);
        this.credentialThumbprint = DigestUtil.sha1Hex(tokenEndpointUri + clientId + CertificateUtil.getThumbprint(keyPair.getCertificate()));
    }

    @Override
    public List<NameValuePair> getPostParams() {
        String assertionToken = this.assertionFactory.CreateAssertionToken();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        params.add(new NameValuePair("client_assertion", assertionToken));
        return params;
    }

    @Override
    public String getCredentialThumbprint() {
        return this.credentialThumbprint;
    }
}

