/*
 * Decompiled with CFR 0.152.
 */
package com.scalified.tree.multinode;

import com.scalified.tree.TraversalAction;
import com.scalified.tree.TreeNode;
import com.scalified.tree.TreeNodeException;
import com.scalified.tree.multinode.MultiTreeNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ArrayMultiTreeNode<T>
extends MultiTreeNode<T> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BRANCHING_FACTOR = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private Object[] subtrees;
    private int subtreesSize;
    private final int branchingFactor;

    public ArrayMultiTreeNode(T data) {
        super(data);
        this.branchingFactor = 10;
        this.subtrees = new Object[this.branchingFactor];
    }

    public ArrayMultiTreeNode(T data, int branchingFactor) {
        super(data);
        if (branchingFactor < 0) {
            throw new IllegalArgumentException("Branching factor can not be negative");
        }
        this.branchingFactor = branchingFactor;
        this.subtrees = new Object[branchingFactor];
    }

    @Override
    public Collection<? extends TreeNode<T>> subtrees() {
        if (this.isLeaf()) {
            return Collections.emptySet();
        }
        HashSet<TreeNode> subtrees = new HashSet<TreeNode>(this.subtreesSize);
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode subtree = (TreeNode)this.subtrees[i];
            subtrees.add(subtree);
        }
        return subtrees;
    }

    @Override
    public boolean add(TreeNode<T> subtree) {
        if (subtree == null) {
            return false;
        }
        ArrayMultiTreeNode.linkParent(subtree, this);
        this.ensureSubtreesCapacity(this.subtreesSize + 1);
        this.subtrees[this.subtreesSize++] = subtree;
        return true;
    }

    private void ensureSubtreesCapacity(int minSubtreesCapacity) {
        if (minSubtreesCapacity > this.subtrees.length) {
            this.increaseSubtreesCapacity(minSubtreesCapacity);
        }
    }

    private void increaseSubtreesCapacity(int minSubtreesCapacity) {
        int oldSubtreesCapacity = this.subtrees.length;
        int newSubtreesCapacity = oldSubtreesCapacity + (oldSubtreesCapacity >> 1);
        if (newSubtreesCapacity < minSubtreesCapacity) {
            newSubtreesCapacity = minSubtreesCapacity;
        }
        if (newSubtreesCapacity > 0x7FFFFFF7) {
            if (minSubtreesCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newSubtreesCapacity = minSubtreesCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
        this.subtrees = Arrays.copyOf(this.subtrees, newSubtreesCapacity);
    }

    @Override
    public boolean dropSubtree(TreeNode<T> subtree) {
        if (subtree == null || this.isLeaf() || subtree.isRoot()) {
            return false;
        }
        int mSubtreeIndex = this.indexOf(subtree);
        if (mSubtreeIndex < 0) {
            return false;
        }
        int mNumShift = this.subtreesSize - mSubtreeIndex - 1;
        if (mNumShift > 0) {
            System.arraycopy(this.subtrees, mSubtreeIndex + 1, this.subtrees, mSubtreeIndex, mNumShift);
        }
        this.subtrees[--this.subtreesSize] = null;
        ArrayMultiTreeNode.unlinkParent(subtree);
        return true;
    }

    private int indexOf(TreeNode<T> subtree) {
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode mSubtree = (TreeNode)this.subtrees[i];
            if (!mSubtree.equals(subtree)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        if (!this.isLeaf()) {
            for (int i = 0; i < this.subtreesSize; ++i) {
                TreeNode subtree = (TreeNode)this.subtrees[i];
                ArrayMultiTreeNode.unlinkParent(subtree);
            }
            this.subtrees = new Object[this.branchingFactor];
            this.subtreesSize = 0;
        }
    }

    @Override
    public TreeNode.TreeNodeIterator iterator() {
        return new TreeNode.TreeNodeIterator(){

            @Override
            protected TreeNode<T> leftMostNode() {
                return (TreeNode)ArrayMultiTreeNode.this.subtrees[0];
            }

            @Override
            protected TreeNode<T> rightSiblingNode() {
                ArrayMultiTreeNode mParent = (ArrayMultiTreeNode)ArrayMultiTreeNode.this.parent;
                int rightSiblingNodeIndex = mParent.indexOf(ArrayMultiTreeNode.this) + 1;
                return rightSiblingNodeIndex <= mParent.subtreesSize ? (TreeNode)mParent.subtrees[rightSiblingNodeIndex] : null;
            }
        };
    }

    @Override
    public boolean isLeaf() {
        return this.subtreesSize == 0;
    }

    @Override
    public boolean hasSubtree(TreeNode<T> subtree) {
        if (subtree == null || this.isLeaf() || subtree.isRoot()) {
            return false;
        }
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode mSubtree = (TreeNode)this.subtrees[i];
            if (!subtree.equals(mSubtree)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode subtree = (TreeNode)this.subtrees[i];
            if (subtree.equals(node)) {
                return true;
            }
            if (!subtree.contains(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        if (this.dropSubtree(node)) {
            return true;
        }
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode subtree = (TreeNode)this.subtrees[i];
            if (!subtree.remove(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void traversePreOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            action.perform(this);
            if (!this.isLeaf()) {
                for (int i = 0; i < this.subtreesSize; ++i) {
                    TreeNode subtree = (TreeNode)this.subtrees[i];
                    subtree.traversePreOrder(action);
                }
            }
        }
    }

    @Override
    public void traversePostOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            if (!this.isLeaf()) {
                for (int i = 0; i < this.subtreesSize; ++i) {
                    TreeNode subtree = (TreeNode)this.subtrees[i];
                    subtree.traversePostOrder(action);
                }
            }
            action.perform(this);
        }
    }

    @Override
    public int height() {
        if (this.isLeaf()) {
            return 0;
        }
        int height = 0;
        for (int i = 0; i < this.subtreesSize; ++i) {
            TreeNode subtree = (TreeNode)this.subtrees[i];
            height = Math.max(height, subtree.height());
        }
        return height + 1;
    }

    @Override
    public boolean addSubtrees(Collection<? extends MultiTreeNode<T>> subtrees) {
        if (ArrayMultiTreeNode.areAllNulls(subtrees)) {
            return false;
        }
        for (MultiTreeNode<T> subtree : subtrees) {
            ArrayMultiTreeNode.linkParent(subtree, this);
        }
        Object[] subtreesArray = subtrees.toArray();
        int subtreesArrayLength = subtreesArray.length;
        this.ensureSubtreesCapacity(this.subtreesSize + subtreesArrayLength);
        System.arraycopy(subtreesArray, 0, this.subtrees, this.subtreesSize, subtreesArrayLength);
        this.subtreesSize += subtreesArrayLength;
        return subtreesArrayLength != 0;
    }

    @Override
    public Collection<? extends MultiTreeNode<T>> siblings() {
        if (this.isRoot()) {
            String message = String.format("Unable to find the siblings. The tree node %1$s is root", this.root());
            throw new TreeNodeException(message);
        }
        ArrayMultiTreeNode mParent = (ArrayMultiTreeNode)this.parent;
        int parentSubtreesSize = mParent.subtreesSize;
        if (parentSubtreesSize == 1) {
            return Collections.emptySet();
        }
        Object[] parentSubtreeObjects = mParent.subtrees;
        HashSet<MultiTreeNode> siblings = new HashSet<MultiTreeNode>(parentSubtreesSize - 1);
        for (int i = 0; i < parentSubtreesSize; ++i) {
            MultiTreeNode parentSubtree = (MultiTreeNode)parentSubtreeObjects[i];
            if (parentSubtree.equals(this)) continue;
            siblings.add(parentSubtree);
        }
        return siblings;
    }
}

