/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.data;

import com.scandit.datacapture.core.common.geometry.Quadrilateral;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeLocalizedOnlyBarcode {
    public abstract Quadrilateral getLocation();

    public abstract int getFrameId();

    private static final class CppProxy
    extends NativeLocalizedOnlyBarcode {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public Quadrilateral getLocation() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getLocation(this.nativeRef);
        }

        private native Quadrilateral native_getLocation(long var1);

        @Override
        public int getFrameId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getFrameId(this.nativeRef);
        }

        private native int native_getFrameId(long var1);
    }
}

