/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.capture;

import com.scandit.datacapture.barcode.tracking.impl.data.NativeTrackedBarcode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeTrackingSession {
    public abstract ArrayList<Integer> getRemovedTrackedBarcodes();

    public abstract HashMap<Integer, NativeTrackedBarcode> getTrackedBarcodes();

    public abstract ArrayList<NativeTrackedBarcode> getAddedTrackedBarcodes();

    public abstract ArrayList<NativeTrackedBarcode> getUpdatedTrackedBarcodes();

    private static final class CppProxy
    extends NativeBarcodeTrackingSession {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ArrayList<Integer> getRemovedTrackedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getRemovedTrackedBarcodes(this.nativeRef);
        }

        private native ArrayList<Integer> native_getRemovedTrackedBarcodes(long var1);

        @Override
        public HashMap<Integer, NativeTrackedBarcode> getTrackedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getTrackedBarcodes(this.nativeRef);
        }

        private native HashMap<Integer, NativeTrackedBarcode> native_getTrackedBarcodes(long var1);

        @Override
        public ArrayList<NativeTrackedBarcode> getAddedTrackedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getAddedTrackedBarcodes(this.nativeRef);
        }

        private native ArrayList<NativeTrackedBarcode> native_getAddedTrackedBarcodes(long var1);

        @Override
        public ArrayList<NativeTrackedBarcode> getUpdatedTrackedBarcodes() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getUpdatedTrackedBarcodes(this.nativeRef);
        }

        private native ArrayList<NativeTrackedBarcode> native_getUpdatedTrackedBarcodes(long var1);
    }
}

