/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FailDotExpression;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.PreparationContext;
import com.schibsted.spt.data.jslt.impl.Scope;

public class FunctionDeclaration
extends AbstractNode
implements Function,
ExpressionNode {
    private String name;
    private String[] parameters;
    private int[] parameterSlots;
    private LetExpression[] lets;
    private ExpressionNode body;
    private int stackFrameSize;

    public FunctionDeclaration(String name, String[] parameters, LetExpression[] lets, ExpressionNode body) {
        super(null);
        this.name = name;
        this.parameters = parameters;
        this.parameterSlots = new int[parameters.length];
        this.lets = lets;
        this.body = body;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMinArguments() {
        return this.parameters.length;
    }

    @Override
    public int getMaxArguments() {
        return this.parameters.length;
    }

    @Override
    public JsonNode call(JsonNode input, JsonNode[] arguments) {
        throw new JsltException("INTERNAL ERROR!");
    }

    public JsonNode call(Scope scope, JsonNode input, JsonNode[] arguments) {
        scope.enterFunction(this.stackFrameSize);
        for (int ix = 0; ix < arguments.length; ++ix) {
            scope.setValue(this.parameterSlots[ix], arguments[ix]);
        }
        NodeUtils.evalLets(scope, input, this.lets);
        JsonNode value = this.body.apply(scope, input);
        scope.leaveFunction();
        return value;
    }

    @Override
    public ExpressionNode optimize() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].optimize();
        }
        this.body = this.body.optimize();
        return this;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode context) {
        throw new JsltException("INTERNAL ERROR");
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        FailDotExpression fail = new FailDotExpression(null, "function declaration");
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].computeMatchContexts(fail);
        }
        this.body.computeMatchContexts(fail);
    }

    @Override
    public void prepare(PreparationContext ctx) {
        int ix;
        ctx.scope.enterFunction();
        for (ix = 0; ix < this.parameters.length; ++ix) {
            this.parameterSlots[ix] = ctx.scope.registerParameter(this.parameters[ix], this.location);
        }
        for (ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].register(ctx.scope);
            this.lets[ix].prepare(ctx);
        }
        this.body.prepare(ctx);
        this.stackFrameSize = ctx.scope.getStackFrameSize();
        ctx.scope.leaveFunction();
    }
}

