/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.LetInfo;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.ParameterInfo;
import com.schibsted.spt.data.jslt.impl.VariableExpression;
import com.schibsted.spt.data.jslt.impl.VariableInfo;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ScopeManager {
    private StackFrame globalFrame = new StackFrame();
    private Deque<ScopeFrame> scopes = new ArrayDeque<ScopeFrame>();
    private StackFrame functionFrame;
    private Deque<ScopeFrame> functionScopes;
    private Deque<ScopeFrame> current = this.scopes;
    private StackFrame currentFrame = this.globalFrame;
    private Map<String, Integer> parameterSlots = new HashMap<String, Integer>();
    public static final int UNFOUND = -1;

    public int getStackFrameSize() {
        return this.currentFrame.nextSlot;
    }

    public Map<String, Integer> getParameterSlots() {
        return this.parameterSlots;
    }

    public void enterFunction() {
        this.functionFrame = new StackFrame();
        this.functionScopes = new ArrayDeque<ScopeFrame>();
        this.current = this.functionScopes;
        this.currentFrame = this.functionFrame;
        this.enterScope();
    }

    public void leaveFunction() {
        this.functionScopes = null;
        this.current = this.scopes;
        this.currentFrame = this.globalFrame;
    }

    public void enterScope() {
        this.current.push(new ScopeFrame(this.functionScopes != null, this.currentFrame));
    }

    public void leaveScope() {
        this.current.pop();
    }

    public VariableInfo registerVariable(LetExpression let) {
        LetInfo info = new LetInfo(let);
        this.current.peek().registerVariable(info);
        return info;
    }

    public int registerParameter(String parameter, Location loc) {
        return this.current.peek().registerVariable(new ParameterInfo(parameter, loc));
    }

    public VariableInfo resolveVariable(VariableExpression variable) {
        VariableInfo var;
        String name = variable.getVariable();
        for (ScopeFrame scope : this.current) {
            var = scope.resolveVariable(name);
            if (var == null) continue;
            return var;
        }
        if (this.functionScopes != null) {
            for (ScopeFrame scope : this.scopes) {
                var = scope.resolveVariable(name);
                if (var == null) continue;
                return var;
            }
        }
        ParameterInfo var2 = new ParameterInfo(name, variable.getLocation());
        int slot = this.scopes.getLast().registerVariable(var2);
        this.parameterSlots.put(name, slot);
        return var2;
    }

    private static class StackFrame {
        private int nextSlot;

        private StackFrame() {
        }
    }

    private static class ScopeFrame {
        private boolean inFunction;
        private StackFrame parent;
        private Map<String, VariableInfo> variables;

        public ScopeFrame(boolean inFunction, StackFrame parent) {
            this.inFunction = inFunction;
            this.variables = new HashMap<String, VariableInfo>();
            this.parent = parent;
        }

        public int registerVariable(VariableInfo variable) {
            String name = variable.getName();
            if (this.variables.containsKey(name)) {
                throw new JsltException("Duplicate variable declaration " + name, variable.getLocation());
            }
            int level = this.inFunction ? 0 : 0x10000000;
            int slot = level | this.parent.nextSlot++;
            variable.setSlot(slot);
            this.variables.put(name, variable);
            return slot;
        }

        public VariableInfo resolveVariable(String name) {
            return this.variables.get(name);
        }
    }
}

