/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sirius.kernel.commons.Watch;
import sirius.kernel.di.std.Register;
import sirius.kernel.nls.NLS;

@Register(classes={APILog.class})
public class APILog {
    private final List<Entry> entries = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getEntries(int start, int count) {
        ArrayList result = Lists.newArrayList();
        List<Entry> list = this.entries;
        synchronized (list) {
            Iterator<Entry> iter = this.entries.iterator();
            while (iter.hasNext() && start > 0) {
                iter.next();
                --start;
            }
            while (iter.hasNext() && count > 0) {
                result.add(iter.next());
                --count;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String function, String description, Result result, Watch watch) {
        List<Entry> list = this.entries;
        synchronized (list) {
            this.entries.add(0, new Entry(function, description, result.name(), watch.duration()));
            if (this.entries.size() > 250) {
                this.entries.remove(this.entries.size() - 1);
            }
        }
    }

    public static class Entry {
        private String tod = NLS.toUserString((Object)LocalDateTime.now());
        private String function;
        private String description;
        private String result;
        private String duration;

        public String getFunction() {
            return this.function;
        }

        public String getDescription() {
            return this.description;
        }

        public String getResult() {
            return this.result;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getTod() {
            return this.tod;
        }

        public String getCSS() {
            if ("ERROR".equals(this.result)) {
                return "error";
            }
            if ("REJECTED".equals(this.result)) {
                return "warning";
            }
            return "";
        }

        protected Entry(String function, String description, String result, String duration) {
            this.function = function;
            this.description = description;
            this.result = result;
            this.duration = duration;
        }
    }

    public static enum Result {
        OK,
        REJECTED,
        ERROR;

    }
}

