/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ninja.Storage;
import sirius.kernel.commons.Strings;
import sirius.kernel.di.std.Part;
import sirius.kernel.di.std.Register;
import sirius.web.http.WebContext;

@Register(classes={Aws4HashCalculator.class})
public class Aws4HashCalculator {
    protected static final Pattern AWS_AUTH4_PATTERN = Pattern.compile("AWS4-HMAC-SHA256 Credential=([^/]+)/([^/]+)/([^/]+)/s3/aws4_request, SignedHeaders=([^,]+), Signature=(.+)");
    @Part
    private Storage storage;

    public boolean supports(WebContext ctx) {
        Matcher aws4Header = this.buildMatcher(ctx);
        return aws4Header.matches();
    }

    private Matcher initializedMatcher(WebContext ctx) {
        Matcher matcher = this.buildMatcher(ctx);
        return matcher.matches() ? matcher : null;
    }

    private Matcher buildMatcher(WebContext ctx) {
        return AWS_AUTH4_PATTERN.matcher(ctx.getHeaderValue((CharSequence)"Authorization").asString(""));
    }

    public String computeHash(WebContext ctx) throws Exception {
        Matcher aws4Header = this.initializedMatcher(ctx);
        byte[] dateKey = this.hmacSHA256(("AWS4" + this.storage.getAwsSecretKey()).getBytes(Charsets.UTF_8), aws4Header.group(2));
        byte[] dateRegionKey = this.hmacSHA256(dateKey, aws4Header.group(3));
        byte[] dateRegionServiceKey = this.hmacSHA256(dateRegionKey, "s3");
        byte[] signingKey = this.hmacSHA256(dateRegionServiceKey, "aws4_request");
        byte[] signedData = this.hmacSHA256(signingKey, this.buildStringToSign(ctx));
        return BaseEncoding.base16().lowerCase().encode(signedData);
    }

    private String buildStringToSign(WebContext ctx) {
        StringBuilder canonicalRequest = this.buildCanonicalRequest(ctx);
        Matcher aws4Header = this.initializedMatcher(ctx);
        return "AWS4-HMAC-SHA256\n" + this.getAmazonDateHeader(ctx) + "\n" + this.getAmazonDateHeader(ctx).substring(0, 8) + "/" + aws4Header.group(3) + "/s3/aws4_request\n" + this.hashedCanonicalRequest(canonicalRequest);
    }

    private String getAmazonDateHeader(WebContext ctx) {
        return ctx.getHeaderValue((CharSequence)"x-amz-date").asString();
    }

    private StringBuilder buildCanonicalRequest(WebContext ctx) {
        Matcher aws4Header = this.initializedMatcher(ctx);
        StringBuilder canonicalRequest = new StringBuilder(ctx.getRequest().method().name());
        canonicalRequest.append("\n");
        canonicalRequest.append(ctx.getRequestedURI());
        canonicalRequest.append("\n");
        canonicalRequest.append(ctx.getQueryString());
        canonicalRequest.append("\n");
        for (String name : aws4Header.group(4).split(";")) {
            canonicalRequest.append(name.trim());
            canonicalRequest.append(":");
            canonicalRequest.append(Strings.join((Iterable)ctx.getRequest().headers().getAll(name), (String)",").trim());
            canonicalRequest.append("\n");
        }
        canonicalRequest.append("\n");
        canonicalRequest.append(aws4Header.group(4));
        canonicalRequest.append("\n");
        canonicalRequest.append(ctx.getHeader((CharSequence)"x-amz-content-sha256"));
        return canonicalRequest;
    }

    private String hashedCanonicalRequest(StringBuilder canonicalRequest) {
        return Hashing.sha256().hashString((CharSequence)canonicalRequest, Charsets.UTF_8).toString();
    }

    private byte[] hmacSHA256(byte[] key, String value) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(keySpec);
        return mac.doFinal(value.getBytes(Charsets.UTF_8));
    }
}

