/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import java.util.regex.Pattern;
import ninja.Aws4HashCalculator;
import ninja.AwsLegacyHashCalculator;
import sirius.kernel.di.std.Part;
import sirius.kernel.di.std.Register;
import sirius.kernel.health.Exceptions;
import sirius.kernel.health.Log;
import sirius.web.http.WebContext;
import sirius.web.security.UserContext;

@Register(classes={AwsHashCalculator.class})
public class AwsHashCalculator {
    protected static final Pattern AWS_AUTH_PATTERN = Pattern.compile("AWS ([^:]+):(.*)");
    @Part
    private Aws4HashCalculator aws4HashCalculator;
    @Part
    private AwsLegacyHashCalculator legacyHashCalculator;

    public String computeHash(WebContext ctx, String pathPrefix) {
        try {
            return this.doComputeHash(ctx, pathPrefix);
        }
        catch (Throwable e) {
            throw Exceptions.handle((Log)UserContext.LOG, (Throwable)e);
        }
    }

    private String doComputeHash(WebContext ctx, String pathPrefix) throws Exception {
        if (this.aws4HashCalculator.supports(ctx)) {
            return this.aws4HashCalculator.computeHash(ctx);
        }
        return this.legacyHashCalculator.computeHash(ctx, pathPrefix);
    }
}

