/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ninja.Storage;
import sirius.kernel.commons.Strings;
import sirius.kernel.di.std.Part;
import sirius.kernel.di.std.Register;
import sirius.web.http.WebContext;

@Register(classes={AwsLegacyHashCalculator.class})
public class AwsLegacyHashCalculator {
    @Part
    private Storage storage;
    private static final List<String> SIGNED_PARAMETERS = Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "response-content-type", "response-content-language", "response-expires", "response-cache-control", "response-content-disposition", "response-content-encoding");

    public String computeHash(WebContext ctx, String pathPrefix) throws Exception {
        StringBuilder stringToSign = new StringBuilder(ctx.getRequest().method().name());
        stringToSign.append("\n");
        stringToSign.append(ctx.getHeaderValue((CharSequence)"Content-MD5").asString(""));
        stringToSign.append("\n");
        stringToSign.append(ctx.getHeaderValue((CharSequence)"Content-Type").asString(""));
        stringToSign.append("\n");
        String date = ctx.get("Expires").asString(ctx.getHeaderValue((CharSequence)"Date").asString(""));
        if (ctx.getHeaderValue((CharSequence)"x-amz-date").isNull()) {
            stringToSign.append(date);
        }
        stringToSign.append("\n");
        HttpHeaders requestHeaders = ctx.getRequest().headers();
        List headers = requestHeaders.names().stream().filter(this::relevantAmazonHeader).map(name -> this.toHeaderStringRepresentation((String)name, requestHeaders)).sorted().collect(Collectors.toList());
        for (Object header : headers) {
            stringToSign.append((String)header);
            stringToSign.append("\n");
        }
        stringToSign.append(pathPrefix).append(ctx.getRequestedURI().substring(3));
        int separator = 63;
        for (String parameterName : ctx.getParameterNames().stream().sorted().collect(Collectors.toList())) {
            if (!SIGNED_PARAMETERS.contains(parameterName)) continue;
            stringToSign.append((char)separator).append(parameterName);
            String parameterValue = ctx.get(parameterName).asString();
            if (Strings.isFilled((Object)parameterValue)) {
                stringToSign.append("=").append(parameterValue);
            }
            separator = 38;
        }
        SecretKeySpec keySpec = new SecretKeySpec(this.storage.getAwsSecretKey().getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(keySpec);
        byte[] result = mac.doFinal(stringToSign.toString().getBytes(Charsets.UTF_8.name()));
        return BaseEncoding.base64().encode(result);
    }

    private boolean relevantAmazonHeader(String name) {
        return name.toLowerCase().startsWith("x-amz-");
    }

    private String toHeaderStringRepresentation(String headerName, HttpHeaders requestHeaders) {
        return headerName.toLowerCase().trim() + ":" + Strings.join((Iterable)requestHeaders.getAll(headerName), (String)",").trim();
    }
}

