/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ninja.S3Controller;
import ninja.Storage;
import ninja.StoredObject;
import sirius.kernel.cache.Cache;
import sirius.kernel.cache.CacheManager;
import sirius.kernel.cache.ValueComputer;
import sirius.kernel.commons.Strings;
import sirius.kernel.health.Counter;
import sirius.kernel.health.Exceptions;
import sirius.kernel.health.Log;
import sirius.kernel.xml.Attribute;
import sirius.kernel.xml.XMLStructuredOutput;

public class Bucket {
    private File file;
    private static Cache<String, Boolean> publicAccessCache = CacheManager.createCache((String)"public-bucket-access");

    public Bucket(File file) {
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public void delete() {
        for (File child : this.file.listFiles()) {
            child.delete();
        }
        this.file.delete();
    }

    public void create() {
        if (!this.file.exists()) {
            this.file.mkdirs();
        }
    }

    public List<StoredObject> getObjects() {
        ArrayList result = Lists.newArrayList();
        for (File child : this.file.listFiles()) {
            if (!child.isFile() || child.getName().startsWith("__")) continue;
            result.add(new StoredObject(child));
        }
        return result;
    }

    public void outputObjects(XMLStructuredOutput output, int limit, @Nullable String marker, @Nullable String prefix) {
        ListFileTreeVisitor visitor = new ListFileTreeVisitor(output, limit, marker, prefix);
        output.beginOutput("ListBucketResult", new Attribute[]{Attribute.set((String)"xmlns", (Object)"http://s3.amazonaws.com/doc/2006-03-01/")});
        output.property("Name", (Object)this.getName());
        output.property("MaxKeys", (Object)limit);
        output.property("Marker", (Object)marker);
        output.property("Prefix", (Object)prefix);
        try {
            Files.walkFileTree(this.file.toPath(), visitor);
        }
        catch (IOException e) {
            Exceptions.handle((Throwable)e);
        }
        output.property("IsTruncated", (Object)(limit > 0 && visitor.getCount() > (long)limit ? 1 : 0));
        output.endOutput();
    }

    public boolean isPrivate() {
        return (Boolean)publicAccessCache.get((Object)this.getName(), (ValueComputer)new ValueComputer<String, Boolean>(){

            @Nullable
            public Boolean compute(@Nonnull String key) {
                return Bucket.this.getPublicMarkerFile().exists();
            }
        }) == false;
    }

    private File getPublicMarkerFile() {
        return new File(this.file, "__ninja_public");
    }

    public void makePrivate() {
        if (this.getPublicMarkerFile().exists()) {
            this.getPublicMarkerFile().delete();
            publicAccessCache.put((Object)this.getName(), (Object)false);
        }
    }

    public void makePublic() {
        if (!this.getPublicMarkerFile().exists()) {
            try {
                new FileOutputStream(this.getPublicMarkerFile()).close();
            }
            catch (IOException e) {
                throw Exceptions.handle((Log)Storage.LOG, (Throwable)e);
            }
        }
        publicAccessCache.put((Object)this.getName(), (Object)true);
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public StoredObject getObject(String id) {
        if (id.contains("..") || id.contains("/") || id.contains("\\")) {
            throw Exceptions.createHandled().withSystemErrorMessage("Invalid object name: %s. A object name must not contain '..' '/' or '\\'", new Object[]{id}).handle();
        }
        return new StoredObject(new File(this.file, id));
    }

    private static class ListFileTreeVisitor
    extends SimpleFileVisitor<Path> {
        Counter objectCount;
        XMLStructuredOutput output;
        int limit;
        String marker;
        String prefix;
        boolean useLimit;
        boolean usePrefix;
        boolean markerReached;

        protected ListFileTreeVisitor(XMLStructuredOutput output, int limit, @Nullable String marker, @Nullable String prefix) {
            this.output = output;
            this.limit = limit;
            this.marker = marker;
            this.prefix = prefix;
            this.objectCount = new Counter();
            this.useLimit = limit > 0;
            this.usePrefix = Strings.isFilled((Object)prefix);
            if (this.usePrefix) {
                this.prefix = prefix.replace('/', '_');
            }
            this.markerReached = Strings.isEmpty((Object)marker);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            File file = path.toFile();
            String name = file.getName();
            if (!file.isFile() || name.startsWith("__")) {
                return FileVisitResult.CONTINUE;
            }
            if (!this.markerReached) {
                if (this.marker.equals(name)) {
                    this.markerReached = true;
                }
            } else {
                StoredObject object = new StoredObject(file);
                if ((!this.usePrefix || name.startsWith(this.prefix)) && this.useLimit) {
                    long numObjects = this.objectCount.inc();
                    if (numObjects <= (long)this.limit) {
                        this.output.beginObject("Contents");
                        this.output.property("Key", (Object)file.getName());
                        this.output.property("LastModified", (Object)S3Controller.ISO_INSTANT.format(object.getLastModifiedInstant()));
                        this.output.property("Size", (Object)file.length());
                        this.output.property("StorageClass", (Object)"STANDARD");
                        String etag = null;
                        try {
                            etag = com.google.common.io.Files.hash((File)file, (HashFunction)Hashing.md5()).toString();
                        }
                        catch (IOException e) {
                            Exceptions.ignore((Throwable)e);
                        }
                        this.output.property("ETag", (Object)etag);
                        this.output.endObject();
                    } else {
                        return FileVisitResult.TERMINATE;
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        public long getCount() {
            return this.objectCount.getCount();
        }
    }
}

