/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ninja.APILog;
import ninja.Bucket;
import ninja.Storage;
import ninja.StoredObject;
import sirius.kernel.di.std.Part;
import sirius.kernel.di.std.Register;
import sirius.kernel.health.Exceptions;
import sirius.kernel.health.HandledException;
import sirius.kernel.health.Log;
import sirius.web.controller.Controller;
import sirius.web.controller.Message;
import sirius.web.controller.Routed;
import sirius.web.http.MimeHelper;
import sirius.web.http.Response;
import sirius.web.http.WebContext;
import sirius.web.security.UserContext;

@Register
public class NinjaController
implements Controller {
    @Part
    private Storage storage;
    @Part
    private APILog log;

    public void onError(WebContext ctx, HandledException error) {
        if (error != null) {
            UserContext.message((Message)Message.error((String)error.getMessage()));
        }
        List<Object> buckets = Collections.emptyList();
        try {
            buckets = this.storage.getBuckets();
        }
        catch (HandledException e) {
            UserContext.message((Message)Message.error((String)e.getMessage()));
        }
        ctx.respondWith().template("view/index.html", new Object[]{buckets, this.storage.getBasePath(), this.storage.getAwsAccessKey(), this.storage.getAwsSecretKey()});
    }

    @Routed(value="/")
    public void index(WebContext ctx) {
        if (ctx.isPOST() && ctx.get("bucketName").isFilled()) {
            this.storage.getBucket(ctx.get("bucketName").asString()).create();
            UserContext.message((Message)Message.info((String)"Bucket successfully created."));
        }
        this.onError(ctx, null);
    }

    @Routed(value="/ui/license", priority=99)
    public void license(WebContext ctx) {
        ctx.respondWith().template("view/license.html", new Object[0]);
    }

    @Routed(value="/ui/api", priority=99)
    public void api(WebContext ctx) {
        ctx.respondWith().template("view/api.html", new Object[0]);
    }

    @Routed(value="/ui/log", priority=99)
    public void log(WebContext ctx) {
        boolean canPageNext;
        int start = ctx.get("start").asInt(1) - 1;
        int pageSize = 50;
        List<APILog.Entry> entries = this.log.getEntries(start, pageSize + 1);
        boolean canPagePrev = start > 0;
        boolean bl = canPageNext = entries.size() > pageSize;
        if (canPageNext) {
            entries.remove(entries.size() - 1);
        }
        ctx.respondWith().template("view/log.html", new Object[]{entries, canPagePrev, canPageNext, start + 1 + " - " + (start + entries.size()), Math.max(1, start - pageSize + 1), start + pageSize + 1});
    }

    @Routed(value="/ui/:1")
    public void bucket(WebContext ctx, String bucketName) {
        Bucket bucket = this.storage.getBucket(bucketName);
        ctx.respondWith().template("view/bucket.html", new Object[]{bucket});
    }

    @Routed(value="/ui/:1/:2")
    public void object(WebContext ctx, String bucketName, String id) {
        try {
            Bucket bucket = this.storage.getBucket(bucketName);
            if (!bucket.exists()) {
                ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Bucket does not exist");
                return;
            }
            StoredObject object = bucket.getObject(id);
            if (!object.exists()) {
                ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Object does not exist");
                return;
            }
            Response response = ctx.respondWith();
            for (Map.Entry<Object, Object> entry : object.getProperties()) {
                response.addHeader((CharSequence)entry.getKey().toString(), (Object)entry.getValue().toString());
            }
            response.file(object.getFile());
        }
        catch (Exception e) {
            ctx.respondWith().error(HttpResponseStatus.BAD_REQUEST, Exceptions.handle((Log)UserContext.LOG, (Throwable)e));
        }
    }

    @Routed(priority=99, value="/ui/:1/upload")
    public void uploadFile(WebContext ctx, String bucket) {
        try {
            String name = ctx.get("filename").asString(ctx.get("qqfile").asString());
            Bucket storageBucket = this.storage.getBucket(bucket);
            StoredObject object = storageBucket.getObject(name);
            try (InputStream inputStream = ctx.getContent();
                 FileOutputStream out = new FileOutputStream(object.getFile());){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)out);
            }
            TreeMap properties = Maps.newTreeMap();
            properties.put(HttpHeaderNames.CONTENT_TYPE.toString(), ctx.getHeaderValue((CharSequence)HttpHeaderNames.CONTENT_TYPE).asString(MimeHelper.guessMimeType((String)name)));
            HashCode hash = Files.hash((File)object.getFile(), (HashFunction)Hashing.md5());
            String md5 = BaseEncoding.base64().encode(hash.asBytes());
            properties.put("Content-MD5", md5);
            object.storeProperties(properties);
            ctx.respondWith().direct(HttpResponseStatus.OK, "{ success: true }");
        }
        catch (IOException e) {
            UserContext.handle((Throwable)e);
            ctx.respondWith().direct(HttpResponseStatus.OK, "{ success: false }");
        }
    }

    @Routed(priority=99, value="/ui/:1/delete")
    public void deleteBucket(WebContext ctx, String bucket) {
        this.storage.getBucket(bucket).delete();
        UserContext.message((Message)Message.info((String)"Bucket successfully deleted."));
        this.onError(ctx, null);
    }

    @Routed(value="/ui/:1/:2/delete")
    public void deleteObject(WebContext ctx, String bucketName, String id) {
        StoredObject object;
        Bucket bucket = this.storage.getBucket(bucketName);
        if (bucket.exists() && (object = bucket.getObject(id)).exists()) {
            object.delete();
            UserContext.message((Message)Message.info((String)"Object successfully deleted."));
        }
        this.bucket(ctx, bucketName);
    }

    @Routed(priority=99, value="/ui/:1/makePublic")
    public void makePublic(WebContext ctx, String bucket) {
        Bucket storageBucket = this.storage.getBucket(bucket);
        storageBucket.makePublic();
        UserContext.message((Message)Message.info((String)"ACLs successfully changed"));
        ctx.respondWith().template("view/bucket.html", new Object[]{storageBucket});
    }

    @Routed(priority=99, value="/ui/:1/makePrivate")
    public void makePrivate(WebContext ctx, String bucket) {
        Bucket storageBucket = this.storage.getBucket(bucket);
        storageBucket.makePrivate();
        UserContext.message((Message)Message.info((String)"ACLs successfully changed"));
        ctx.respondWith().template("view/bucket.html", new Object[]{storageBucket});
    }
}

