/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import ninja.APILog;
import ninja.Aws4HashCalculator;
import ninja.AwsHashCalculator;
import ninja.Bucket;
import ninja.Storage;
import ninja.StoredObject;
import sirius.kernel.async.CallContext;
import sirius.kernel.commons.Strings;
import sirius.kernel.commons.Value;
import sirius.kernel.di.std.ConfigValue;
import sirius.kernel.di.std.Part;
import sirius.kernel.di.std.Register;
import sirius.kernel.health.Counter;
import sirius.kernel.health.Exceptions;
import sirius.kernel.health.HandledException;
import sirius.kernel.xml.Attribute;
import sirius.kernel.xml.XMLReader;
import sirius.kernel.xml.XMLStructuredOutput;
import sirius.web.controller.Controller;
import sirius.web.controller.Routed;
import sirius.web.http.InputStreamHandler;
import sirius.web.http.Response;
import sirius.web.http.WebContext;

@Register
public class S3Controller
implements Controller {
    public static final String HTTP_HEADER_NAME_ETAG = "ETag";
    @Part
    private Storage storage;
    @Part
    private APILog log;
    @Part
    private AwsHashCalculator hashCalculator;
    @ConfigValue(value="storage.multipartDir")
    private String multipartDir;
    private Set<String> multipartUploads = Collections.synchronizedSet(new TreeSet());
    private Counter uploadIdCounter = new Counter();
    public static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter().withChronology(IsoChronology.INSTANCE).withZone(ZoneOffset.UTC);
    private static final Map<String, String> headerOverrides = Maps.newTreeMap();

    public void onError(WebContext ctx, HandledException error) {
        this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, error.getMessage());
    }

    private String getAuthHash(WebContext ctx) {
        Value authorizationHeaderValue = ctx.getHeaderValue((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (!authorizationHeaderValue.isFilled()) {
            return ctx.get("Signature").getString();
        }
        String authentication = Strings.isEmpty((Object)authorizationHeaderValue.getString()) ? "" : authorizationHeaderValue.getString();
        Matcher m = AwsHashCalculator.AWS_AUTH_PATTERN.matcher(authentication);
        if (m.matches()) {
            return m.group(2);
        }
        m = Aws4HashCalculator.AWS_AUTH4_PATTERN.matcher(authentication);
        if (m.matches()) {
            return m.group(5);
        }
        return null;
    }

    private void signalObjectError(WebContext ctx, HttpResponseStatus status, String message) {
        if (ctx.getRequest().method() == HttpMethod.HEAD) {
            ctx.respondWith().status(status);
        } else {
            ctx.respondWith().error(status, message);
        }
        this.log.log("OBJECT " + ctx.getRequest().method().name(), message + " - " + ctx.getRequestedURI(), APILog.Result.ERROR, CallContext.getCurrent().getWatch());
    }

    private void signalObjectSuccess(WebContext ctx) {
        this.log.log("OBJECT " + ctx.getRequest().method().name(), ctx.getRequestedURI(), APILog.Result.OK, CallContext.getCurrent().getWatch());
    }

    @Routed(value="/s3", priority=99)
    public void listBuckets(WebContext ctx) {
        XMLStructuredOutput out;
        HttpMethod method = ctx.getRequest().method();
        if (HttpMethod.GET == method) {
            List<Bucket> buckets = this.storage.getBuckets();
            Response response = ctx.respondWith();
            response.setHeader((CharSequence)"Content-Type", (Object)"application/xml");
            out = response.xml();
            out.beginOutput("ListAllMyBucketsResult", new Attribute[]{Attribute.set((String)"xmlns", (Object)"http://s3.amazonaws.com/doc/2006-03-01/")});
            out.beginObject("Owner");
            out.property("ID", (Object)"initiatorId");
            out.property("DisplayName", (Object)"initiatorName");
            out.endObject();
            out.beginObject("Buckets");
            for (Bucket bucket : buckets) {
                out.beginObject("Bucket");
                out.property("Name", (Object)bucket.getName());
                out.property("CreationDate", (Object)ISO_INSTANT.format(Instant.ofEpochMilli(bucket.getFile().lastModified())));
                out.endObject();
            }
        } else {
            throw new IllegalArgumentException(ctx.getRequest().method().name());
        }
        out.endObject();
        out.endOutput();
    }

    @Routed(value="/s3/:1", priority=99)
    public void bucket(WebContext ctx, String bucketName) {
        Bucket bucket = this.storage.getBucket(bucketName);
        HttpMethod method = ctx.getRequest().method();
        if (HttpMethod.HEAD == method) {
            if (bucket.exists()) {
                this.signalObjectSuccess(ctx);
                ctx.respondWith().status(HttpResponseStatus.OK);
            } else {
                this.signalObjectError(ctx, HttpResponseStatus.NOT_FOUND, "Bucket does not exist");
            }
        } else if (HttpMethod.GET == method) {
            if (bucket.exists()) {
                this.listObjects(ctx, bucket);
            } else {
                this.signalObjectError(ctx, HttpResponseStatus.NOT_FOUND, "Bucket does not exist");
            }
        } else if (HttpMethod.DELETE == method) {
            bucket.delete();
            this.signalObjectSuccess(ctx);
            ctx.respondWith().status(HttpResponseStatus.OK);
        } else {
            throw new IllegalArgumentException(ctx.getRequest().method().name());
        }
    }

    @Routed(value="/s3/:1", priority=99, preDispatchable=true)
    public void bucket(WebContext ctx, String bucketName, InputStreamHandler in) {
        Bucket bucket = this.storage.getBucket(bucketName);
        HttpMethod method = ctx.getRequest().method();
        if (HttpMethod.PUT != method) {
            throw new IllegalArgumentException(ctx.getRequest().method().name());
        }
        bucket.create();
        this.signalObjectSuccess(ctx);
        ctx.respondWith().status(HttpResponseStatus.OK);
    }

    @Routed(value="/s3/:1/:2/**")
    public void object(WebContext ctx, String bucketName, String objectId, List<String> idList) throws Exception {
        Bucket bucket = this.storage.getBucket(bucketName);
        String id = S3Controller.getIdsAsString(objectId, idList);
        String uploadId = ctx.get("uploadId").asString();
        if (!this.checkObjectRequest(ctx, bucket, id)) {
            return;
        }
        HttpMethod method = ctx.getRequest().method();
        if (HttpMethod.HEAD == method) {
            this.getObject(ctx, bucket, id, false);
        } else if (HttpMethod.GET == method) {
            if (Strings.isFilled((Object)uploadId)) {
                this.getPartList(ctx, bucket, id, uploadId);
            } else {
                this.getObject(ctx, bucket, id, true);
            }
        } else if (HttpMethod.DELETE == method) {
            if (Strings.isFilled((Object)uploadId)) {
                this.abortMultipartUpload(ctx, bucket, id, uploadId);
            } else {
                this.deleteObject(ctx, bucket, id);
            }
        } else {
            throw new IllegalArgumentException(ctx.getRequest().method().name());
        }
    }

    @Routed(value="/s3/:1/:2/**", preDispatchable=true)
    public void object(WebContext ctx, String bucketName, String objectId, List<String> idList, InputStreamHandler in) throws Exception {
        Bucket bucket = this.storage.getBucket(bucketName);
        String id = S3Controller.getIdsAsString(objectId, idList);
        String uploadId = ctx.get("uploadId").asString();
        if (!this.checkObjectRequest(ctx, bucket, id)) {
            return;
        }
        HttpMethod method = ctx.getRequest().method();
        if (HttpMethod.PUT == method) {
            Value copy = ctx.getHeaderValue((CharSequence)"x-amz-copy-source");
            if (copy.isFilled()) {
                this.copyObject(ctx, bucket, id, copy.asString());
            } else if (ctx.hasParameter("partNumber") && Strings.isFilled((Object)uploadId)) {
                this.multiObject(ctx, bucket, id, uploadId, ctx.get("partNumber").asString(), in);
            } else {
                this.putObject(ctx, bucket, id, in);
            }
        } else if (HttpMethod.POST == method) {
            if (ctx.hasParameter("uploads")) {
                this.startMultipartUpload(ctx, bucket, id);
            } else if (Strings.isFilled((Object)uploadId)) {
                this.completeMultipartUpload(ctx, bucket, id, uploadId, in);
            }
        } else {
            throw new IllegalArgumentException(ctx.getRequest().method().name());
        }
    }

    private boolean checkObjectRequest(WebContext ctx, Bucket bucket, String id) {
        if (Strings.isEmpty((Object)id)) {
            this.signalObjectError(ctx, HttpResponseStatus.NOT_FOUND, "Please provide an object id");
            return false;
        }
        if (!this.objectCheckAuth(ctx, bucket)) {
            return false;
        }
        if (!bucket.exists()) {
            if (this.storage.isAutocreateBuckets()) {
                bucket.create();
            } else {
                this.signalObjectError(ctx, HttpResponseStatus.NOT_FOUND, "Bucket does not exist");
                return false;
            }
        }
        return true;
    }

    private static String getIdsAsString(String objectId, List<String> idList) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(objectId);
        ids.addAll(idList);
        return ids.stream().filter(i -> Strings.isFilled((Object)i)).collect(Collectors.joining("/")).replace('/', '_');
    }

    private boolean objectCheckAuth(WebContext ctx, Bucket bucket) {
        String hash = this.getAuthHash(ctx);
        if (hash != null) {
            String expectedHash = this.computeHash(ctx, "");
            String alternativeHash = this.computeHash(ctx, "/s3");
            if (!expectedHash.equals(hash) && !alternativeHash.equals(hash)) {
                ctx.respondWith().error(HttpResponseStatus.UNAUTHORIZED, Strings.apply((String)"Invalid Hash (Expected: %s, Found: %s)", (Object[])new Object[]{expectedHash, hash}));
                this.log.log("OBJECT " + ctx.getRequest().method().name(), ctx.getRequestedURI(), APILog.Result.REJECTED, CallContext.getCurrent().getWatch());
                return false;
            }
        }
        if (bucket.isPrivate() && !ctx.get("noAuth").isFilled() && hash == null) {
            ctx.respondWith().error(HttpResponseStatus.UNAUTHORIZED, "Authentication required");
            this.log.log("OBJECT " + ctx.getRequest().method().name(), ctx.getRequestedURI(), APILog.Result.REJECTED, CallContext.getCurrent().getWatch());
            return false;
        }
        return true;
    }

    private String computeHash(WebContext ctx, String pathPrefix) {
        return this.hashCalculator.computeHash(ctx, pathPrefix);
    }

    private void listObjects(WebContext ctx, Bucket bucket) {
        int maxKeys = ctx.get("max-keys").asInt(1000);
        String marker = ctx.get("marker").asString();
        String prefix = ctx.get("prefix").asString();
        Response response = ctx.respondWith();
        response.setHeader((CharSequence)"Content-Type", (Object)"application/xml");
        bucket.outputObjects(response.xml(), maxKeys, marker, prefix);
    }

    private void deleteObject(WebContext ctx, Bucket bucket, String id) {
        StoredObject object = bucket.getObject(id);
        object.delete();
        ctx.respondWith().status(HttpResponseStatus.OK);
        this.signalObjectSuccess(ctx);
    }

    private void putObject(WebContext ctx, Bucket bucket, String id, InputStreamHandler inputStream) throws Exception {
        StoredObject object = bucket.getObject(id);
        if (inputStream == null) {
            this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, "No content posted");
            return;
        }
        FileOutputStream out = new FileOutputStream(object.getFile());
        Object object2 = null;
        try {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (object2 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        TreeMap properties = Maps.newTreeMap();
        for (String name : ctx.getRequest().headers().names()) {
            String nameLower = name.toLowerCase();
            if (!nameLower.startsWith("x-amz-meta-") && !"content-md5".equals(nameLower) && !"content-type".equals(nameLower) && !"x-amz-acl".equals(nameLower)) continue;
            properties.put(name, ctx.getHeader((CharSequence)name));
        }
        HashCode hash = Files.hash((File)object.getFile(), (HashFunction)Hashing.md5());
        String md5 = BaseEncoding.base64().encode(hash.asBytes());
        if (properties.containsKey("Content-MD5") && !md5.equals(properties.get("Content-MD5"))) {
            object.delete();
            this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, Strings.apply((String)"Invalid MD5 checksum (Input: %s, Expected: %s)", (Object[])new Object[]{properties.get("Content-MD5"), md5}));
            return;
        }
        object.storeProperties(properties);
        Response response = ctx.respondWith();
        response.addHeader((CharSequence)HTTP_HEADER_NAME_ETAG, (Object)this.etag(hash)).status(HttpResponseStatus.OK);
        response.addHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, (Object)HTTP_HEADER_NAME_ETAG);
        this.signalObjectSuccess(ctx);
    }

    private String etag(HashCode hash) {
        return "\"" + hash + "\"";
    }

    private void copyObject(WebContext ctx, Bucket bucket, String id, String copy) throws IOException {
        StoredObject object = bucket.getObject(id);
        if (!copy.contains("/")) {
            this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, "Source must contain '/'");
            return;
        }
        String srcBucketName = copy.substring(1, copy.lastIndexOf("/"));
        String srcId = copy.substring(copy.lastIndexOf("/") + 1);
        Bucket srcBucket = this.storage.getBucket(srcBucketName);
        if (!srcBucket.exists()) {
            this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, "Source bucket does not exist");
            return;
        }
        StoredObject src = srcBucket.getObject(srcId);
        if (!src.exists()) {
            this.signalObjectError(ctx, HttpResponseStatus.BAD_REQUEST, "Source object does not exist");
            return;
        }
        Files.copy((File)src.getFile(), (File)object.getFile());
        if (src.getPropertiesFile().exists()) {
            Files.copy((File)src.getPropertiesFile(), (File)object.getPropertiesFile());
        }
        HashCode hash = Files.hash((File)object.getFile(), (HashFunction)Hashing.md5());
        String etag = this.etag(hash);
        XMLStructuredOutput structuredOutput = ctx.respondWith().addHeader((CharSequence)HTTP_HEADER_NAME_ETAG, (Object)etag).xml();
        structuredOutput.beginOutput("CopyObjectResult");
        structuredOutput.beginObject("LastModified");
        structuredOutput.text((Object)ISO_INSTANT.format(object.getLastModifiedInstant()));
        structuredOutput.endObject();
        structuredOutput.beginObject(HTTP_HEADER_NAME_ETAG);
        structuredOutput.text((Object)etag);
        structuredOutput.endObject();
        structuredOutput.endOutput();
        this.signalObjectSuccess(ctx);
    }

    private void getObject(WebContext ctx, Bucket bucket, String id, boolean sendFile) throws Exception {
        StoredObject object = bucket.getObject(id);
        if (!object.exists()) {
            this.signalObjectError(ctx, HttpResponseStatus.NOT_FOUND, "Object does not exist");
            return;
        }
        Response response = ctx.respondWith();
        for (Map.Entry<Object, Object> entry : object.getProperties()) {
            response.addHeader((CharSequence)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : this.getOverridenHeaders(ctx).entrySet()) {
            response.setHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        HashCode hash = Files.hash((File)object.getFile(), (HashFunction)Hashing.md5());
        response.addHeader((CharSequence)HTTP_HEADER_NAME_ETAG, (Object)BaseEncoding.base16().encode(hash.asBytes()));
        response.addHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, (Object)HTTP_HEADER_NAME_ETAG);
        if (sendFile) {
            response.file(object.getFile());
        } else {
            response.status(HttpResponseStatus.OK);
        }
        this.signalObjectSuccess(ctx);
    }

    private void startMultipartUpload(WebContext ctx, Bucket bucket, String id) {
        Response response = ctx.respondWith();
        TreeMap properties = Maps.newTreeMap();
        for (String name : ctx.getRequest().headers().names()) {
            String nameLower = name.toLowerCase();
            if (!nameLower.startsWith("x-amz-meta-") && !"content-md5".equals(nameLower) && !"content-type".equals(nameLower) && !"x-amz-acl".equals(nameLower)) continue;
            properties.put(name, ctx.getHeader((CharSequence)name));
            response.addHeader((CharSequence)name, (Object)ctx.getHeader((CharSequence)name));
        }
        response.setHeader((CharSequence)"Content-Type", (Object)"application/xml");
        String uploadId = String.valueOf(this.uploadIdCounter.inc());
        this.multipartUploads.add(uploadId);
        this.getUploadDir(uploadId).mkdirs();
        XMLStructuredOutput out = response.xml();
        out.beginOutput("InitiateMultipartUploadResult");
        out.property("Bucket", (Object)bucket.getName());
        out.property("Key", (Object)id);
        out.property("UploadId", (Object)uploadId);
        out.endOutput();
    }

    private void multiObject(WebContext ctx, Bucket bucket, String id, String uploadId, String partNumber, InputStreamHandler part) {
        if (!this.multipartUploads.contains(uploadId)) {
            ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Multipart Upload does not exist");
            return;
        }
        String etag = "";
        try {
            File partFile = new File(this.getUploadDir(uploadId), partNumber);
            partFile.deleteOnExit();
            Files.touch((File)partFile);
            try (FileOutputStream out = new FileOutputStream(partFile);){
                ByteStreams.copy((InputStream)part, (OutputStream)out);
            }
            part.close();
            etag = Files.hash((File)partFile, (HashFunction)Hashing.md5()).toString();
        }
        catch (IOException e) {
            Exceptions.handle((Throwable)e);
        }
        Response response = ctx.respondWith();
        response.setHeader((CharSequence)HTTP_HEADER_NAME_ETAG, (Object)etag);
        response.addHeader((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, (Object)HTTP_HEADER_NAME_ETAG);
        response.status(HttpResponseStatus.OK);
    }

    private void completeMultipartUpload(WebContext ctx, Bucket bucket, String id, String uploadId, InputStreamHandler in) {
        if (!this.multipartUploads.remove(uploadId)) {
            ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Multipart Upload does not exist");
            return;
        }
        HashMap<Integer, File> parts = new HashMap<Integer, File>();
        XMLReader reader = new XMLReader();
        reader.addHandler("Part", part -> {
            int number = part.queryValue("PartNumber").asInt(0);
            parts.put(number, new File(this.getUploadDir(uploadId), String.valueOf(number)));
        });
        try {
            reader.parse((InputStream)in);
        }
        catch (IOException e) {
            Exceptions.handle((Throwable)e);
        }
        File file = this.combineParts(id, uploadId, parts);
        file.deleteOnExit();
        if (!file.exists()) {
            ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Multipart File does not exist");
            return;
        }
        try {
            StoredObject object = bucket.getObject(id);
            Files.move((File)file, (File)object.getFile());
            S3Controller.delete(this.getUploadDir(uploadId));
            String etag = Files.hash((File)object.getFile(), (HashFunction)Hashing.md5()).toString();
            XMLStructuredOutput out = ctx.respondWith().xml();
            out.beginOutput("CompleteMultipartUploadResult");
            out.property("Location", (Object)"");
            out.property("Bucket", (Object)bucket.getName());
            out.property("Key", (Object)id);
            out.property(HTTP_HEADER_NAME_ETAG, (Object)etag);
            out.endOutput();
        }
        catch (IOException e) {
            Exceptions.ignore((Throwable)e);
            ctx.respondWith().error(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Could not build response");
        }
    }

    private File getUploadDir(String uploadId) {
        return new File(this.multipartDir + "/" + uploadId);
    }

    private File combineParts(String id, String uploadId, Map<Integer, File> parts) {
        File file = new File(this.getUploadDir(uploadId), id);
        ByteBuffer[] buffers = new ByteBuffer[parts.size()];
        try {
            for (Map.Entry<Integer, File> entry : parts.entrySet()) {
                RandomAccessFile raf = new RandomAccessFile(entry.getValue(), "r");
                Throwable throwable = null;
                try {
                    FileChannel channel = raf.getChannel();
                    buffers[entry.getKey().intValue() - 1] = channel.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (raf == null) continue;
                    if (throwable != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    raf.close();
                }
            }
            file.createNewFile();
            FileOutputStream outFile = new FileOutputStream(file);
            try (FileChannel out = outFile.getChannel();){
                out.write(buffers);
            }
        }
        catch (IOException e) {
            Exceptions.handle((Throwable)e);
        }
        return file;
    }

    private void abortMultipartUpload(WebContext ctx, Bucket bucket, String id, String uploadId) {
        System.out.println("aborting multiupload");
        this.multipartUploads.remove(uploadId);
        ctx.respondWith().status(HttpResponseStatus.OK);
        File uploadDir = this.getUploadDir(uploadId);
        S3Controller.delete(uploadDir);
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    S3Controller.delete(new File(file, temp));
                }
                S3Controller.delete(file);
            }
        } else {
            file.delete();
        }
    }

    private void getPartList(WebContext ctx, Bucket bucket, String id, String uploadId) {
        if (!this.multipartUploads.contains(uploadId)) {
            ctx.respondWith().error(HttpResponseStatus.NOT_FOUND, "Multipart Upload does not exist");
            return;
        }
        Response response = ctx.respondWith();
        response.setHeader((CharSequence)"Content-Type", (Object)"application/xml");
        XMLStructuredOutput out = response.xml();
        out.beginOutput("ListPartsResult");
        out.property("Bucket", (Object)bucket.getName());
        out.property("Key", (Object)id);
        out.property("UploadId", (Object)uploadId);
        out.beginObject("Initiator");
        out.property("ID", (Object)"initiatorId");
        out.property("DisplayName", (Object)"initiatorName");
        out.endObject();
        out.beginObject("Owner");
        out.property("ID", (Object)"initiatorId");
        out.property("DisplayName", (Object)"initiatorName");
        out.endObject();
        File uploadDir = this.getUploadDir(uploadId);
        int marker = ctx.get("part-number-marker").asInt(0);
        int maxParts = ctx.get("max-parts").asInt(0);
        out.property("StorageClass", (Object)"STANDARD");
        out.property("PartNumberMarker", (Object)marker);
        if (marker + maxParts < uploadDir.list().length) {
            out.property("NextPartNumberMarker", (Object)(marker + maxParts + 1));
        }
        if (Strings.isFilled((Object)maxParts)) {
            out.property("MaxParts", (Object)maxParts);
        }
        boolean truncated = 0 < maxParts && maxParts < uploadDir.list().length;
        out.property("IsTruncated", (Object)truncated);
        for (File part : uploadDir.listFiles()) {
            out.beginObject("Part");
            out.property("PartNumber", (Object)part.getName());
            out.property("LastModified", (Object)ISO_INSTANT.format(Instant.ofEpochMilli(part.lastModified())));
            try {
                out.property(HTTP_HEADER_NAME_ETAG, (Object)Files.hash((File)part, (HashFunction)Hashing.md5()).toString());
            }
            catch (IOException e) {
                Exceptions.ignore((Throwable)e);
            }
            out.property("Size", (Object)part.length());
            out.endObject();
        }
        out.endOutput();
    }

    private Map<String, String> getOverridenHeaders(WebContext ctx) {
        TreeMap overrides = Maps.newTreeMap();
        for (Map.Entry<String, String> entry : headerOverrides.entrySet()) {
            String header = entry.getValue().toString();
            String val = ctx.getParameter(entry.getKey().toString());
            if (val == null) continue;
            overrides.put(header, val);
        }
        return overrides;
    }

    static {
        headerOverrides.put("response-content-type", "Content-Type");
        headerOverrides.put("response-content-language", "Content-Language");
        headerOverrides.put("response-expires", "Expires");
        headerOverrides.put("response-cache-control", "Cache-Control");
        headerOverrides.put("response-content-disposition", "Content-Disposition");
        headerOverrides.put("response-content-encoding", "Content-Encoding");
    }
}

