/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ninja.Bucket;
import sirius.kernel.Sirius;
import sirius.kernel.di.std.ConfigValue;
import sirius.kernel.di.std.Register;
import sirius.kernel.health.Exceptions;
import sirius.kernel.health.Log;
import sirius.kernel.nls.NLS;

@Register(classes={Storage.class})
public class Storage {
    private File baseDir;
    protected static final Log LOG = Log.get((String)"storage");
    @ConfigValue(value="storage.awsAccessKey")
    private String awsAccessKey;
    @ConfigValue(value="storage.awsSecretKey")
    private String awsSecretKey;
    @ConfigValue(value="storage.autocreateBuckets")
    private boolean autocreateBuckets;

    protected File getBaseDir() {
        this.baseDir = this.getBaseDirUnchecked();
        if (!this.baseDir.exists()) {
            throw Exceptions.handle().to(LOG).withSystemErrorMessage("Basedir '%s' does not exist!", new Object[]{this.baseDir.getAbsolutePath()}).handle();
        }
        if (!this.baseDir.isDirectory()) {
            throw Exceptions.handle().to(LOG).withSystemErrorMessage("Basedir '%s' is not a directory!", new Object[]{this.baseDir.getAbsolutePath()}).handle();
        }
        return this.baseDir;
    }

    private File getBaseDirUnchecked() {
        if (this.baseDir == null) {
            if (Sirius.isStartedAsTest()) {
                this.baseDir = new File(System.getProperty("java.io.tmpdir"), "s3ninja_test");
                this.baseDir.mkdirs();
            } else {
                this.baseDir = new File(Sirius.getConfig().getString("storage.baseDir"));
            }
        }
        return this.baseDir;
    }

    public String getBasePath() {
        StringBuilder sb = new StringBuilder(this.getBaseDirUnchecked().getAbsolutePath());
        if (!this.getBaseDirUnchecked().exists()) {
            sb.append(" (non-existent!)");
        } else if (!this.getBaseDirUnchecked().isDirectory()) {
            sb.append(" (no directory!)");
        } else {
            sb.append(" (Free: " + NLS.formatSize((long)this.getBaseDir().getFreeSpace()) + ")");
        }
        return sb.toString();
    }

    public List<Bucket> getBuckets() {
        ArrayList result = Lists.newArrayList();
        for (File file : this.getBaseDir().listFiles()) {
            if (!file.isDirectory()) continue;
            result.add(new Bucket(file));
        }
        return result;
    }

    public Bucket getBucket(String bucket) {
        if (bucket.contains("..") || bucket.contains("/") || bucket.contains("\\")) {
            throw Exceptions.createHandled().withSystemErrorMessage("Invalid bucket name: %s. A bucket name must not contain '..' '/' or '\\'", new Object[]{bucket}).handle();
        }
        return new Bucket(new File(this.getBaseDir(), bucket));
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public boolean isAutocreateBuckets() {
        return this.autocreateBuckets;
    }
}

