/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sirius.kernel.health.Exceptions;
import sirius.kernel.nls.NLS;

public class StoredObject {
    private File file;

    public StoredObject(File file) {
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getSize() {
        return NLS.formatSize((long)this.file.length());
    }

    public String getLastModified() {
        return NLS.toUserString((Object)this.getLastModifiedInstant());
    }

    public Instant getLastModifiedInstant() {
        return Instant.ofEpochMilli(this.file.lastModified());
    }

    public void delete() {
        this.file.delete();
        this.getPropertiesFile().delete();
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Set<Map.Entry<Object, Object>> getProperties() {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(this.getPropertiesFile());){
            props.load(in);
        }
        catch (IOException e) {
            Exceptions.ignore((Throwable)e);
        }
        return props.entrySet();
    }

    public File getPropertiesFile() {
        return new File(this.file.getParentFile(), "__ninja_" + this.file.getName() + ".properties");
    }

    public void storeProperties(Map<String, String> properties) throws IOException {
        Properties props = new Properties();
        properties.entrySet().stream().forEach(e -> props.setProperty((String)e.getKey(), (String)e.getValue()));
        try (FileOutputStream out = new FileOutputStream(this.getPropertiesFile());){
            props.store(out, "");
        }
    }
}

