/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.dse.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;

/**
 * Specialized materialized view metadata for DSE.
 *
 * <p>This type exists only for future extensibility; currently, it is identical to {@link
 * ViewMetadata}.
 *
 * <p>Note that all returned {@link ColumnMetadata} can be cast to {@link DseColumnMetadata}.
 */
public interface DseViewMetadata extends DseRelationMetadata, ViewMetadata {}
