/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model;

import com.google.common.base.Preconditions;
import com.scylladb.cdc.model.RetryBackoff;
import java.util.concurrent.ThreadLocalRandom;

public class ExponentialRetryBackoffWithJitter
implements RetryBackoff {
    private final int maximumBackoffMs;
    private final int backoffBase;
    private final double jitterPercentage;
    private final int maxJitterMs;

    public ExponentialRetryBackoffWithJitter(int backoffBase, int maximumBackoffMs, double jitterPercentage) {
        Preconditions.checkArgument((maximumBackoffMs > 0 ? 1 : 0) != 0);
        this.maximumBackoffMs = maximumBackoffMs;
        Preconditions.checkArgument((backoffBase > 0 ? 1 : 0) != 0);
        this.backoffBase = backoffBase;
        Preconditions.checkArgument((jitterPercentage > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((jitterPercentage <= 1.0 ? 1 : 0) != 0);
        this.jitterPercentage = jitterPercentage;
        this.maxJitterMs = maximumBackoffMs;
    }

    public ExponentialRetryBackoffWithJitter(int backoffBase, int maximumBackoffMs, double jitterPercentage, int maxJitterMs) {
        Preconditions.checkArgument((maximumBackoffMs > 0 ? 1 : 0) != 0);
        this.maximumBackoffMs = maximumBackoffMs;
        Preconditions.checkArgument((backoffBase > 0 ? 1 : 0) != 0);
        this.backoffBase = backoffBase;
        Preconditions.checkArgument((jitterPercentage > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((jitterPercentage <= 1.0 ? 1 : 0) != 0);
        this.jitterPercentage = jitterPercentage;
        Preconditions.checkArgument(((double)maxJitterMs >= 0.0 ? 1 : 0) != 0);
        this.maxJitterMs = Math.min(maxJitterMs, maximumBackoffMs);
    }

    @Override
    public int getRetryBackoffTimeMs(int tryAttempt) {
        double backoff = Math.min((double)this.maximumBackoffMs, (double)this.backoffBase * Math.pow(2.0, tryAttempt));
        double jitter = Math.min(ThreadLocalRandom.current().nextDouble(this.jitterPercentage) * backoff, (double)this.maxJitterMs);
        return (int)(backoff - jitter);
    }
}

