/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class FutureUtils {
    public static <T> CompletableFuture<T> thenComposeExceptionally(CompletableFuture<T> fut, Function<Throwable, ? extends CompletionStage<T>> exceptionally) {
        return ((CompletableFuture)fut.handle((res, ex) -> new ComposeExceptionallyWrapper<Object>(res, (Throwable)ex))).thenCompose(wrapper -> {
            if (wrapper.throwable == null) {
                return CompletableFuture.completedFuture(wrapper.result);
            }
            return (CompletionStage)exceptionally.apply(wrapper.throwable);
        });
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    private static class ComposeExceptionallyWrapper<T> {
        T result;
        Throwable throwable;

        public ComposeExceptionallyWrapper(T result, Throwable throwable) {
            this.result = result;
            this.throwable = throwable;
        }
    }
}

