/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.scylladb.cdc.model.VNodeId;
import java.nio.ByteBuffer;

public final class StreamId
implements Comparable<StreamId> {
    private final ByteBuffer value;

    public StreamId(ByteBuffer value) {
        this.value = (ByteBuffer)Preconditions.checkNotNull((Object)value);
    }

    public VNodeId getVNodeId() {
        long lowerDword = this.value.getLong(this.value.position() + 8);
        long vNodeId = (lowerDword & 0x3FFFFF0L) >> 4;
        return new VNodeId((int)vNodeId);
    }

    public ByteBuffer getValue() {
        return this.value.asReadOnlyBuffer();
    }

    public boolean equals(Object o) {
        return o instanceof StreamId && this.value.equals(((StreamId)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        byte[] buf = new byte[16];
        this.value.duplicate().get(buf, 0, 16);
        return String.format("StreamId(%s)", BaseEncoding.base16().encode(buf, 0, 16));
    }

    @Override
    public int compareTo(StreamId o) {
        return this.value.compareTo(o.value);
    }
}

