/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model;

import com.google.common.base.Preconditions;
import com.scylladb.cdc.model.GenerationId;
import com.scylladb.cdc.model.TableName;
import com.scylladb.cdc.model.VNodeId;
import java.util.Objects;

public final class TaskId
implements Comparable<TaskId> {
    private final GenerationId generationId;
    private final VNodeId vNodeId;
    private final TableName table;

    public TaskId(GenerationId generationId, VNodeId vNodeId, TableName table) {
        this.generationId = (GenerationId)Preconditions.checkNotNull((Object)generationId);
        this.vNodeId = (VNodeId)Preconditions.checkNotNull((Object)vNodeId);
        this.table = (TableName)Preconditions.checkNotNull((Object)table);
    }

    public GenerationId getGenerationId() {
        return this.generationId;
    }

    public VNodeId getvNodeId() {
        return this.vNodeId;
    }

    public TableName getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        return o instanceof TaskId && this.generationId.equals(((TaskId)o).generationId) && this.vNodeId.equals(((TaskId)o).vNodeId) && this.table.equals(((TaskId)o).table);
    }

    public int hashCode() {
        return Objects.hash(this.generationId, this.vNodeId, this.table);
    }

    public String toString() {
        return String.format("TaskId(%s, %s, %s)", this.generationId, this.vNodeId, this.table);
    }

    @Override
    public int compareTo(TaskId o) {
        int cmp = this.generationId.compareTo(o.generationId);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.vNodeId.compareTo(o.vNodeId);
        return cmp != 0 ? cmp : this.table.compareTo(o.table);
    }
}

