/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.time.temporal.TemporalUnit;
import java.util.Date;

public final class Timestamp
implements Comparable<Timestamp> {
    private static final SimpleDateFormat TIMESTAMP_TO_STRING_FORMATTER = new SimpleDateFormat("dd/MM/yyyy, HH:mm:ss.SSS");
    private final Date value;

    public Timestamp(Date value) {
        this.value = (Date)Preconditions.checkNotNull((Object)value);
    }

    public Date toDate() {
        return this.value;
    }

    public Timestamp plus(long amount, TemporalUnit unit) {
        return new Timestamp(Date.from(this.toDate().toInstant().plus(amount, unit)));
    }

    public boolean equals(Object o) {
        return o instanceof Timestamp && this.value.equals(((Timestamp)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return String.format("Timestamp(%s)", TIMESTAMP_TO_STRING_FORMATTER.format(this.value));
    }

    @Override
    public int compareTo(Timestamp o) {
        return this.value.compareTo(o.value);
    }
}

