/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;

public class ChangeTime
implements Comparable<ChangeTime> {
    private final UUID time;

    public ChangeTime(UUID time) {
        this.time = (UUID)Preconditions.checkNotNull((Object)time);
    }

    public UUID getUUID() {
        return this.time;
    }

    public long getTimestamp() {
        return (this.time.timestamp() - 122192928000000000L) / 10L;
    }

    public Date getDate() {
        return new Date(this.getTimestamp() / 1000L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeTime that = (ChangeTime)o;
        return this.time.equals(that.time);
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }

    @Override
    public int compareTo(ChangeTime changeTime) {
        return Long.compare(this.time.timestamp(), changeTime.time.timestamp());
    }

    public String toString() {
        return String.format("ChangeTime(%s)", this.time);
    }
}

