/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.worker.ChangeId;
import com.scylladb.cdc.model.worker.ChangeSchema;
import com.scylladb.cdc.model.worker.ChangeTime;
import com.scylladb.cdc.model.worker.cql.Cell;
import com.scylladb.cdc.model.worker.cql.Field;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

public interface RawChange
extends Iterable<Cell> {
    default public ChangeId getId() {
        return new ChangeId(new StreamId(this.getCell("cdc$stream_id").getBytes()), new ChangeTime(this.getCell("cdc$time").getUUID()));
    }

    default public OperationType getOperationType() {
        Byte operation = this.getCell("cdc$operation").getByte();
        return OperationType.parse(operation);
    }

    default public boolean isEndOfBatch() {
        Boolean eob = this.getCell("cdc$end_of_batch").getBoolean();
        return eob != null && eob != false;
    }

    default public int getBatchSequenceNumber() {
        return this.getCell("cdc$batch_seq_no").getInt();
    }

    default public Long getTTL() {
        return this.getCell("cdc$ttl").getLong();
    }

    public ChangeSchema getSchema();

    default public Object getAsObject(String columnName) {
        return this.getAsObject(this.getSchema().getColumnDefinition(columnName));
    }

    public Object getAsObject(ChangeSchema.ColumnDefinition var1);

    default public Cell getCell(String columnName) {
        return this.getCell(this.getSchema().getColumnDefinition(columnName));
    }

    public Cell getCell(ChangeSchema.ColumnDefinition var1);

    default public boolean isNull(String columnName) {
        return this.isNull(this.getSchema().getColumnDefinition(columnName));
    }

    public boolean isNull(ChangeSchema.ColumnDefinition var1);

    default public ByteBuffer getAsUnsafeBytes(String columnName) {
        return this.getAsUnsafeBytes(this.getSchema().getColumnDefinition(columnName));
    }

    public ByteBuffer getAsUnsafeBytes(ChangeSchema.ColumnDefinition var1);

    default public boolean isDeleted(String columnName) {
        return this.isDeleted(this.getSchema().getColumnDefinition(columnName));
    }

    default public boolean isDeleted(ChangeSchema.ColumnDefinition columnDefinition) {
        ChangeSchema.ColumnDefinition deletedColumnDefinition = this.getSchema().getDeletedColumnDefinition(columnDefinition);
        Boolean value = this.getCell(deletedColumnDefinition).getBoolean();
        return value != null && value != false;
    }

    default public Set<Field> getDeletedElements(String columnName) {
        return this.getDeletedElements(this.getSchema().getColumnDefinition(columnName));
    }

    default public Set<Field> getDeletedElements(ChangeSchema.ColumnDefinition columnDefinition) {
        ChangeSchema.ColumnDefinition deletedElementsColumnDefinition = this.getSchema().getDeletedElementsColumnDefinition(columnDefinition);
        return this.getCell(deletedElementsColumnDefinition).getSet();
    }

    @Deprecated
    default public boolean getIsDeleted(String columnName) {
        return this.isDeleted(columnName);
    }

    @Override
    default public Iterator<Cell> iterator() {
        return this.stream().iterator();
    }

    default public Iterator<Cell> nonCdcColumnsIterator() {
        return this.nonCdcColumnsStream().iterator();
    }

    default public Iterator<Cell> cdcColumnsIterator() {
        return this.cdcColumnsStream().iterator();
    }

    default public Stream<Cell> stream() {
        return this.getSchema().getAllColumnDefinitions().stream().map(c -> this.getCell((ChangeSchema.ColumnDefinition)c));
    }

    default public Stream<Cell> nonCdcColumnsStream() {
        return this.getSchema().getNonCdcColumnDefinitions().stream().map(c -> this.getCell((ChangeSchema.ColumnDefinition)c));
    }

    default public Stream<Cell> cdcColumnsStream() {
        return this.getSchema().getCdcColumnDefinitions().stream().map(c -> this.getCell((ChangeSchema.ColumnDefinition)c));
    }

    public static enum OperationType {
        PRE_IMAGE(0),
        ROW_UPDATE(1),
        ROW_INSERT(2),
        ROW_DELETE(3),
        PARTITION_DELETE(4),
        ROW_RANGE_DELETE_INCLUSIVE_LEFT_BOUND(5),
        ROW_RANGE_DELETE_EXCLUSIVE_LEFT_BOUND(6),
        ROW_RANGE_DELETE_INCLUSIVE_RIGHT_BOUND(7),
        ROW_RANGE_DELETE_EXCLUSIVE_RIGHT_BOUND(8),
        POST_IMAGE(9);

        byte operationId;

        private OperationType(byte operationId) {
            this.operationId = operationId;
        }

        public static OperationType parse(byte value) {
            try {
                return OperationType.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException(Byte.toString(value), e);
            }
        }
    }
}

