/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.google.common.base.Preconditions;
import com.scylladb.cdc.model.GenerationId;
import com.scylladb.cdc.model.Timestamp;
import com.scylladb.cdc.model.worker.ChangeId;
import com.scylladb.cdc.model.worker.TimeUUID;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class TaskState {
    private final Timestamp windowStart;
    private final Timestamp windowEnd;
    private final Optional<ChangeId> lastConsumedChangeId;

    public TaskState(Timestamp start, Timestamp end, Optional<ChangeId> lastConsumed) {
        this.windowStart = (Timestamp)Preconditions.checkNotNull((Object)start);
        this.windowEnd = (Timestamp)Preconditions.checkNotNull((Object)end);
        this.lastConsumedChangeId = (Optional)Preconditions.checkNotNull(lastConsumed);
    }

    public Optional<ChangeId> getLastConsumedChangeId() {
        return this.lastConsumedChangeId;
    }

    public UUID getWindowStart() {
        return TimeUUID.startOf(this.windowStart.toDate().getTime());
    }

    public Timestamp getWindowStartTimestamp() {
        return this.windowStart;
    }

    public boolean hasPassed(Timestamp t) {
        return this.windowStart.compareTo(t) > 0;
    }

    public UUID getWindowEnd() {
        return TimeUUID.endOf(this.windowEnd.toDate().getTime() - 1L);
    }

    public Timestamp getWindowEndTimestamp() {
        return this.windowEnd;
    }

    public TaskState moveToNextWindow(long nextWindowSizeMs) {
        return new TaskState(this.windowEnd, this.windowEnd.plus(nextWindowSizeMs, ChronoUnit.MILLIS), Optional.empty());
    }

    public TaskState update(ChangeId seen) {
        return new TaskState(this.windowStart, this.windowEnd, Optional.of(seen));
    }

    public boolean equals(Object other) {
        if (!(other instanceof TaskState)) {
            return false;
        }
        TaskState o = (TaskState)other;
        return this.windowStart.equals(o.windowStart) && this.windowEnd.equals(o.windowEnd) && this.lastConsumedChangeId.equals(o.lastConsumedChangeId);
    }

    public int hashCode() {
        return Objects.hash(this.windowStart, this.windowEnd, this.lastConsumedChangeId);
    }

    public String toString() {
        return String.format("TaskState(%s (%s), %s (%s), %s)", this.getWindowStart(), this.windowStart, this.getWindowEnd(), this.windowEnd, this.lastConsumedChangeId);
    }

    public static TaskState createInitialFor(GenerationId generation, long windowSizeMs) {
        Timestamp generationStart = generation.getGenerationStart();
        return new TaskState(generationStart, generationStart.plus(windowSizeMs, ChronoUnit.MILLIS), Optional.empty());
    }

    public TaskState trimTaskState(Timestamp minimumWindowStart, long windowSizeMs) {
        if (this.windowEnd.compareTo(minimumWindowStart) < 0) {
            return new TaskState(minimumWindowStart, minimumWindowStart.plus(windowSizeMs, ChronoUnit.MILLIS), Optional.empty());
        }
        return this;
    }
}

