/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

class TimeUUID {
    private static final long START_EPOCH = TimeUUID.makeEpoch();
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;

    TimeUUID() {
    }

    protected static UUID startOf(long timestamp) {
        return new UUID(TimeUUID.makeMSB(TimeUUID.fromUnixTimestamp(timestamp)), -9187201950435737472L);
    }

    protected static UUID endOf(long timestamp) {
        return new UUID(TimeUUID.makeMSB(TimeUUID.fromUnixTimestamp(timestamp + 1L) - 1L), 0x7F7F7F7F7F7F7F7FL);
    }

    protected static UUID middleOf(long timestamp) {
        return new UUID(TimeUUID.makeMSB(TimeUUID.fromUnixTimestamp(timestamp) + 5000L), 0L);
    }

    private static long fromUnixTimestamp(long tstamp) {
        return (tstamp - START_EPOCH) * 10000L;
    }

    private static long makeMSB(long timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp) << 32;
        msb |= (0xFFFF00000000L & timestamp) >>> 16;
        msb |= (0xFFF000000000000L & timestamp) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeEpoch() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        c.set(1, 1582);
        c.set(2, 9);
        c.set(5, 15);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }
}

