/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql;

import com.scylladb.cdc.cql.MasterCQL;
import com.scylladb.cdc.model.GenerationId;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.Timestamp;
import com.scylladb.cdc.model.master.GenerationMetadata;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class BaseMasterCQL
implements MasterCQL {
    protected abstract CompletableFuture<Optional<Date>> fetchSmallestGenerationAfter(Date var1);

    protected abstract CompletableFuture<Set<ByteBuffer>> fetchStreamsForGeneration(Date var1);

    @Override
    public CompletableFuture<Optional<GenerationId>> fetchFirstGenerationId() {
        return this.fetchSmallestGenerationAfter(new Date(0L)).thenApply(opt -> opt.map(t2 -> new GenerationId(new Timestamp((Date)t2))));
    }

    private static SortedSet<StreamId> convertStreams(Set<ByteBuffer> input) {
        return input.stream().map(StreamId::new).collect(Collectors.toCollection(() -> new TreeSet()));
    }

    @Override
    public CompletableFuture<GenerationMetadata> fetchGenerationMetadata(GenerationId id) {
        CompletableFuture<Optional<Timestamp>> endFut = this.fetchGenerationEnd(id);
        CompletableFuture<Set<ByteBuffer>> streamsFut = this.fetchStreamsForGeneration(id.getGenerationStart().toDate());
        return endFut.thenCombine(streamsFut, (end, streams) -> new GenerationMetadata(id.getGenerationStart(), (Optional<Timestamp>)end, BaseMasterCQL.convertStreams(streams)));
    }

    @Override
    public CompletableFuture<Optional<Timestamp>> fetchGenerationEnd(GenerationId id) {
        return this.fetchSmallestGenerationAfter(id.getGenerationStart().toDate()).thenApply(opt -> opt.map(Timestamp::new));
    }
}

