/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql;

import com.scylladb.cdc.cql.ReplicaOrdering;
import com.scylladb.cdc.cql.SslConfig;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;

public class CQLConfiguration {
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.QUORUM;
    public final List<InetSocketAddress> contactPoints;
    public final String user;
    public final String password;
    private final ConsistencyLevel consistencyLevel;
    private final String localDCName;
    private final String localRackName;
    private final ReplicaOrdering replicaOrdering;
    public final SslConfig sslConfig;
    public final int queryOptionsFetchSize;
    public final Integer corePoolLocal;
    public final Integer maxPoolLocal;
    public final Integer poolingMaxQueueSize;
    public final Integer poolingMaxRequestsPerConnectionLocal;
    public final Integer poolTimeoutMillis;
    public final int defaultPort;

    private CQLConfiguration(List<InetSocketAddress> contactPoints, String user, String password, ConsistencyLevel consistencyLevel, String localDCName, String localRackName, ReplicaOrdering replicaOrdering, SslConfig sslConfig, int queryOptionsFetchSize, Integer corePoolLocal, Integer maxPoolLocal, Integer poolingMaxQueueSize, Integer poolingMaxRequestsPerConnectionLocal, Integer poolTimeoutMillis, int defaultPort) {
        this.contactPoints = Preconditions.checkNotNull(contactPoints);
        Preconditions.checkArgument(!contactPoints.isEmpty());
        this.defaultPort = defaultPort;
        this.user = user;
        this.password = password;
        Preconditions.checkArgument(this.user == null && this.password == null || this.user != null && this.password != null);
        this.consistencyLevel = Preconditions.checkNotNull(consistencyLevel);
        this.localDCName = localDCName;
        this.localRackName = localRackName;
        this.replicaOrdering = Preconditions.checkNotNull(replicaOrdering);
        this.sslConfig = sslConfig;
        this.queryOptionsFetchSize = queryOptionsFetchSize;
        this.corePoolLocal = corePoolLocal;
        this.maxPoolLocal = maxPoolLocal;
        this.poolingMaxQueueSize = poolingMaxQueueSize;
        this.poolingMaxRequestsPerConnectionLocal = poolingMaxRequestsPerConnectionLocal;
        this.poolTimeoutMillis = poolTimeoutMillis;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getLocalDCName() {
        return this.localDCName;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getLocalRackName() {
        return this.localRackName;
    }

    public ReplicaOrdering getReplicaOrdering() {
        return this.replicaOrdering;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<InetSocketAddress> contactPoints = new ArrayList<InetSocketAddress>();
        private int defaultPort = 9042;
        private String user = null;
        private String password = null;
        private ConsistencyLevel consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;
        private String localDCName = null;
        private String localRackName = null;
        private ReplicaOrdering replicaOrdering = ReplicaOrdering.RANDOM;
        private SslConfig sslConfig = null;
        private int queryOptionsFetchSize = 0;
        private Integer corePoolLocal = null;
        private Integer maxPoolLocal = null;
        private Integer poolingMaxQueueSize = null;
        private Integer poolingMaxRequestsPerConnectionLocal = null;
        private Integer poolTimeoutMillis = null;

        public Builder addContactPoint(InetSocketAddress contactPoint) {
            Preconditions.checkNotNull(contactPoint);
            this.contactPoints.add(contactPoint);
            return this;
        }

        public Builder addContactPoints(Collection<InetSocketAddress> addedContactPoints) {
            for (InetSocketAddress contactPoint : addedContactPoints) {
                this.addContactPoint(contactPoint);
            }
            return this;
        }

        public Builder addContactPoint(String host, int port) {
            Preconditions.checkNotNull(host);
            Preconditions.checkArgument(port > 0 && port < 65536);
            return this.addContactPoint(new InetSocketAddress(host, port));
        }

        public Builder addContactPoint(String host) {
            return this.addContactPoint(host, this.defaultPort);
        }

        public Builder withDefaultPort(int port) {
            this.defaultPort = port;
            return this;
        }

        public Builder withCredentials(String user, String password) {
            this.user = Preconditions.checkNotNull(user);
            this.password = Preconditions.checkNotNull(password);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = Preconditions.checkNotNull(consistencyLevel);
            return this;
        }

        public Builder withLocalDCName(String localDCName) {
            this.localDCName = Preconditions.checkNotNull(localDCName);
            return this;
        }

        public Builder withLocalRackName(String localRackName) {
            this.localRackName = Preconditions.checkNotNull(localRackName);
            return this;
        }

        public Builder withReplicaOrdering(ReplicaOrdering replicaOrdering) {
            this.replicaOrdering = Preconditions.checkNotNull(replicaOrdering);
            return this;
        }

        public Builder withSslConfig(SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder withQueryOptionsFetchSize(int fetchSize) {
            this.queryOptionsFetchSize = fetchSize;
            return this;
        }

        public Builder withCorePoolLocal(Integer corePoolLocal) {
            this.corePoolLocal = corePoolLocal;
            return this;
        }

        public Builder withMaxPoolLocal(Integer maxPoolLocal) {
            this.maxPoolLocal = maxPoolLocal;
            return this;
        }

        public Builder withPoolingMaxQueueSize(Integer poolingMaxQueueSize) {
            this.poolingMaxQueueSize = poolingMaxQueueSize;
            return this;
        }

        public Builder withPoolingMaxRequestsPerConnectionLocal(Integer poolingMaxRequestsPerConnectionLocal) {
            this.poolingMaxRequestsPerConnectionLocal = poolingMaxRequestsPerConnectionLocal;
            return this;
        }

        public Builder withPoolTimeoutMillis(Integer poolTimeoutMillis) {
            this.poolTimeoutMillis = poolTimeoutMillis;
            return this;
        }

        public CQLConfiguration build() {
            return new CQLConfiguration(this.contactPoints, this.user, this.password, this.consistencyLevel, this.localDCName, this.localRackName, this.replicaOrdering, this.sslConfig, this.queryOptionsFetchSize, this.corePoolLocal, this.maxPoolLocal, this.poolingMaxQueueSize, this.poolingMaxRequestsPerConnectionLocal, this.poolTimeoutMillis, this.defaultPort);
        }
    }

    public static enum ConsistencyLevel {
        LOCAL_ONE,
        ONE,
        TWO,
        THREE,
        LOCAL_QUORUM,
        QUORUM,
        ALL;

    }
}

