/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql.driver3;

import com.scylladb.cdc.model.worker.ChangeSchema;
import com.scylladb.cdc.model.worker.cql.Field;
import java.nio.ByteBuffer;
import java.util.Objects;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.io.BaseEncoding;

public class Driver3Field
implements Field {
    private final Object value;
    private final ChangeSchema.DataType dataType;

    public Driver3Field(ChangeSchema.DataType dataType, Object value) {
        this.value = value;
        this.dataType = Preconditions.checkNotNull(dataType);
    }

    @Override
    public ChangeSchema.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getAsObject() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Driver3Field)) {
            return false;
        }
        Driver3Field other = (Driver3Field)obj;
        return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (this.value != null && this.value instanceof ByteBuffer) {
            byte[] valueArray = ((ByteBuffer)this.value).array();
            return BaseEncoding.base16().encode(valueArray, 0, valueArray.length);
        }
        return Objects.toString(this.value);
    }
}

