/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql.driver3;

import com.scylladb.cdc.cql.driver3.Driver3Cell;
import com.scylladb.cdc.cql.driver3.Driver3ToLibraryTranslator;
import com.scylladb.cdc.model.worker.ChangeSchema;
import com.scylladb.cdc.model.worker.RawChange;
import com.scylladb.cdc.model.worker.cql.Cell;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.driver.core.Row;

public final class Driver3RawChange
implements RawChange {
    private final Row row;
    private final ChangeSchema schema;

    public Driver3RawChange(Row row, ChangeSchema schema) {
        this.row = Preconditions.checkNotNull(row);
        this.schema = Preconditions.checkNotNull(schema);
    }

    @Override
    public ChangeSchema getSchema() {
        return this.schema;
    }

    @Override
    public Object getAsObject(ChangeSchema.ColumnDefinition c) {
        if (this.isNull(c)) {
            return null;
        }
        return Driver3ToLibraryTranslator.translate(this.row.getObject(c.getIndex()), c.getCdcLogDataType());
    }

    @Override
    public boolean isNull(ChangeSchema.ColumnDefinition c) {
        return this.row.isNull(c.getIndex());
    }

    @Override
    public ByteBuffer getAsUnsafeBytes(ChangeSchema.ColumnDefinition c) {
        return this.row.getBytesUnsafe(c.getIndex());
    }

    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(", ", "Driver3RawChange(", ")"));
    }

    @Override
    public Cell getCell(ChangeSchema.ColumnDefinition c) {
        return new Driver3Cell(this, c);
    }
}

