/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql.driver3;

import com.scylladb.cdc.model.worker.ChangeSchema;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnDefinitions;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.KeyspaceMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Row;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleType;
import shaded.com.scylladb.cdc.driver3.driver.core.UserType;

class Driver3SchemaFactory {
    private static final String SCYLLA_CDC_LOG_SUFFIX = "_scylla_cdc_log";

    Driver3SchemaFactory() {
    }

    public static ChangeSchema getChangeSchema(Row cdcRow, Metadata metadata) throws UnresolvableSchemaInconsistencyException {
        Preconditions.checkNotNull(cdcRow);
        Preconditions.checkNotNull(metadata);
        String keyspace = cdcRow.getColumnDefinitions().getKeyspace(0);
        String cdcLogTableName = cdcRow.getColumnDefinitions().getTable(0);
        Preconditions.checkArgument(cdcLogTableName.endsWith(SCYLLA_CDC_LOG_SUFFIX));
        String baseTableName = cdcLogTableName.substring(0, cdcLogTableName.length() - SCYLLA_CDC_LOG_SUFFIX.length());
        ColumnDefinitions cdcColumnDefinitions = cdcRow.getColumnDefinitions();
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(keyspace);
        if (keyspaceMetadata == null) {
            throw new UnresolvableSchemaInconsistencyException(String.format("Keyspace '%s' is missing from the cluster metadata.", keyspace));
        }
        TableMetadata tableMetadata = keyspaceMetadata.getTable(baseTableName);
        if (tableMetadata == null) {
            throw new UnresolvableSchemaInconsistencyException(String.format("Table '%s' is missing from the keyspace '%s' metadata.", baseTableName, keyspace));
        }
        BaseTableSchema baseTableSchema = new BaseTableSchema(tableMetadata);
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        for (ColumnDefinitions.Definition cdcColumn : cdcColumnDefinitions) {
            String columnName = cdcColumn.getName();
            ChangeSchema.DataType cdcDataType = Driver3SchemaFactory.translateCdcColumnDataType(cdcColumn.getType());
            ChangeSchema.DataType baseTableDataType = null;
            ChangeSchema.ColumnKind baseTableColumnKind = null;
            if (!columnName.startsWith("cdc$")) {
                baseTableDataType = Driver3SchemaFactory.inferBaseTableDataType(cdcColumnDefinitions, baseTableSchema, cdcColumn, cdcDataType);
                baseTableColumnKind = baseTableSchema.getColumnKind(columnName, cdcColumnDefinitions);
            }
            builder.add(new ChangeSchema.ColumnDefinition(columnName, index++, cdcDataType, baseTableDataType, baseTableColumnKind));
        }
        return new ChangeSchema((List<ChangeSchema.ColumnDefinition>)((Object)builder.build()));
    }

    private static ChangeSchema.DataType inferBaseTableDataType(ColumnDefinitions cdcColumnDefinitions, BaseTableSchema baseTableSchema, ColumnDefinitions.Definition cdcColumn, ChangeSchema.DataType cdcDataType) throws UnresolvableSchemaInconsistencyException {
        if (!cdcDataType.isNative()) {
            boolean hasDeletedElementsColumn = cdcColumnDefinitions.contains("cdc$deleted_elements_" + cdcColumn.getName());
            if (hasDeletedElementsColumn) {
                if (cdcDataType.getCqlType() == ChangeSchema.CqlType.MAP && cdcDataType.getTypeArguments().get(0).getCqlType() == ChangeSchema.CqlType.TIMEUUID && baseTableSchema.isList(cdcColumn.getName())) {
                    return new ChangeSchema.DataType(ChangeSchema.CqlType.LIST, Collections.singletonList(cdcDataType.getTypeArguments().get(1)), false);
                }
                return new ChangeSchema.DataType(cdcDataType, false);
            }
            return cdcDataType;
        }
        return cdcDataType;
    }

    private static ChangeSchema.DataType translateCdcColumnDataType(DataType driverType) {
        List<DataType> driverTypeArguments = driverType.getTypeArguments();
        Preconditions.checkNotNull(driverTypeArguments);
        ImmutableList typeArguments = driverTypeArguments.stream().map(Driver3SchemaFactory::translateCdcColumnDataType).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        switch (driverType.getName()) {
            case ASCII: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.ASCII);
            }
            case BIGINT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.BIGINT);
            }
            case BLOB: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.BLOB);
            }
            case BOOLEAN: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.BOOLEAN);
            }
            case COUNTER: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.COUNTER);
            }
            case DECIMAL: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.DECIMAL);
            }
            case DOUBLE: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.DOUBLE);
            }
            case FLOAT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.FLOAT);
            }
            case INT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.INT);
            }
            case TEXT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TEXT);
            }
            case TIMESTAMP: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TIMESTAMP);
            }
            case UUID: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.UUID);
            }
            case VARCHAR: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.VARCHAR);
            }
            case VARINT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.VARINT);
            }
            case TIMEUUID: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TIMEUUID);
            }
            case INET: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.INET);
            }
            case DATE: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.DATE);
            }
            case TIME: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TIME);
            }
            case SMALLINT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.SMALLINT);
            }
            case TINYINT: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TINYINT);
            }
            case DURATION: {
                return new ChangeSchema.DataType(ChangeSchema.CqlType.DURATION);
            }
            case LIST: {
                Preconditions.checkArgument(typeArguments.size() == 1);
                return new ChangeSchema.DataType(ChangeSchema.CqlType.LIST, typeArguments, true);
            }
            case MAP: {
                Preconditions.checkArgument(typeArguments.size() == 2);
                return new ChangeSchema.DataType(ChangeSchema.CqlType.MAP, typeArguments, true);
            }
            case SET: {
                Preconditions.checkArgument(typeArguments.size() == 1);
                return new ChangeSchema.DataType(ChangeSchema.CqlType.SET, typeArguments, true);
            }
            case UDT: {
                Preconditions.checkArgument(driverType instanceof UserType);
                UserType userType = (UserType)driverType;
                ImmutableMap.Builder<String, ChangeSchema.DataType> fieldsBuilder = new ImmutableMap.Builder<String, ChangeSchema.DataType>();
                for (UserType.Field f : userType) {
                    fieldsBuilder.put(f.getName(), Driver3SchemaFactory.translateCdcColumnDataType(f.getType()));
                }
                ChangeSchema.DataType.UdtType udtType = new ChangeSchema.DataType.UdtType(fieldsBuilder.build(), userType.getKeyspace(), userType.getTypeName());
                return new ChangeSchema.DataType(ChangeSchema.CqlType.UDT, udtType, true);
            }
            case TUPLE: {
                Preconditions.checkArgument(driverType instanceof TupleType);
                TupleType tupleType = (TupleType)driverType;
                typeArguments = tupleType.getComponentTypes().stream().map(Driver3SchemaFactory::translateCdcColumnDataType).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
                Preconditions.checkArgument(!typeArguments.isEmpty());
                return new ChangeSchema.DataType(ChangeSchema.CqlType.TUPLE, typeArguments, true);
            }
        }
        throw new RuntimeException(String.format("Data type %s is currently not supported.", new Object[]{driverType.getName()}));
    }

    public static class UnresolvableSchemaInconsistencyException
    extends Exception {
        private UnresolvableSchemaInconsistencyException(String message) {
            super(message);
        }
    }

    private static class BaseTableSchema {
        private final TableMetadata baseTableSchema;
        private final Set<String> partitionColumns;
        private final Set<String> clusteringColumns;
        private final Set<String> regularColumns;

        public BaseTableSchema(TableMetadata baseTableSchema) {
            this.baseTableSchema = baseTableSchema;
            this.partitionColumns = baseTableSchema.getPartitionKey().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
            this.clusteringColumns = baseTableSchema.getClusteringColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
            this.regularColumns = baseTableSchema.getColumns().stream().map(ColumnMetadata::getName).filter(c -> !this.partitionColumns.contains(c)).filter(c -> !this.clusteringColumns.contains(c)).collect(Collectors.toSet());
        }

        public ChangeSchema.ColumnKind getColumnKind(String columnName, ColumnDefinitions cdcColumnDefinitions) {
            if (this.partitionColumns.contains(columnName)) {
                return ChangeSchema.ColumnKind.PARTITION_KEY;
            }
            if (this.clusteringColumns.contains(columnName)) {
                return ChangeSchema.ColumnKind.CLUSTERING_KEY;
            }
            Set cdcColumnNames = cdcColumnDefinitions.asList().stream().map(ColumnDefinitions.Definition::getName).collect(Collectors.toSet());
            if (!cdcColumnNames.containsAll(this.clusteringColumns)) {
                if (cdcColumnNames.contains(columnName) && this.regularColumns.contains(columnName)) {
                    return ChangeSchema.ColumnKind.REGULAR;
                }
                return ChangeSchema.ColumnKind.CLUSTERING_KEY;
            }
            return ChangeSchema.ColumnKind.REGULAR;
        }

        public boolean isList(String columnName) throws UnresolvableSchemaInconsistencyException {
            boolean isMapTimeuuid;
            ColumnMetadata baseColumnMetadata = this.baseTableSchema.getColumn(columnName);
            if (baseColumnMetadata == null) {
                throw new UnresolvableSchemaInconsistencyException(String.format("Column '%s' in base table metadata is missing, making it impossible to deduce whether it was a LIST at a time of CDC log schema.", columnName));
            }
            boolean isList = baseColumnMetadata.getType().getName() == DataType.Name.LIST;
            boolean bl = isMapTimeuuid = baseColumnMetadata.getType().getName() == DataType.Name.MAP && baseColumnMetadata.getType().getTypeArguments().get(0).getName() == DataType.Name.TIMEUUID;
            if (!isList && !isMapTimeuuid) {
                throw new UnresolvableSchemaInconsistencyException(String.format("The type of column '%s' in base table metadata is %s, making it impossible to deduce whether it was a LIST at a time of CDC log schema.", new Object[]{columnName, baseColumnMetadata.getType().getName()}));
            }
            return isList;
        }
    }
}

