/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql.driver3;

import com.scylladb.cdc.cql.CQLConfiguration;
import com.scylladb.cdc.cql.SslConfig;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.HostDistance;
import shaded.com.scylladb.cdc.driver3.driver.core.PoolingOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.QueryOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.RemoteEndpointAwareNettySSLOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.Session;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.DCAwareRoundRobinPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.LoadBalancingPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.RackAwareRoundRobinPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.RoundRobinPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.TokenAwarePolicy;
import shaded.com.scylladb.cdc.driver3.handler.ssl.SslContext;
import shaded.com.scylladb.cdc.driver3.handler.ssl.SslContextBuilder;
import shaded.com.scylladb.cdc.driver3.handler.ssl.SslProvider;

public class Driver3Session
implements AutoCloseable {
    private final Cluster driverCluster;
    private final Session driverSession;
    private final ConsistencyLevel consistencyLevel;

    public Driver3Session(CQLConfiguration cqlConfiguration) {
        TokenAwarePolicy.ReplicaOrdering replicaOrdering;
        Cluster.Builder clusterBuilder = Cluster.builder().withProtocolVersion(ProtocolVersion.NEWEST_SUPPORTED);
        clusterBuilder = clusterBuilder.withPort(cqlConfiguration.defaultPort).addContactPointsWithPorts(cqlConfiguration.contactPoints);
        PoolingOptions poolingOptions = new PoolingOptions();
        if (cqlConfiguration.poolingMaxQueueSize != null) {
            poolingOptions.setMaxQueueSize(cqlConfiguration.poolingMaxQueueSize);
        }
        if (cqlConfiguration.poolingMaxRequestsPerConnectionLocal != null) {
            poolingOptions.setMaxRequestsPerConnection(HostDistance.LOCAL, cqlConfiguration.poolingMaxRequestsPerConnectionLocal);
        }
        if (cqlConfiguration.maxPoolLocal != null) {
            poolingOptions.setMaxConnectionsPerHost(HostDistance.LOCAL, cqlConfiguration.maxPoolLocal);
        }
        if (cqlConfiguration.corePoolLocal != null) {
            poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, cqlConfiguration.corePoolLocal);
        }
        if (cqlConfiguration.poolTimeoutMillis != null) {
            poolingOptions.setPoolTimeoutMillis(cqlConfiguration.poolTimeoutMillis);
        }
        clusterBuilder.withPoolingOptions(poolingOptions);
        if (cqlConfiguration.sslConfig != null) {
            SslContext context;
            SslConfig sslConfig = cqlConfiguration.sslConfig;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            System.out.println(sslConfig.getClass().getProtectionDomain().getCodeSource().getLocation());
            sslContextBuilder.sslProvider(SslProvider.valueOf(sslConfig.sslProviderString));
            if (sslConfig.trustStorePath != null) {
                TrustManagerFactory trustManagerFactory;
                KeyStore trustKeyStore = this.createKeyStore(sslConfig.trustStorePath, sslConfig.trustStorePassword);
                try {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustKeyStore);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Exception while creating TrustManagerFactory", e);
                }
                catch (KeyStoreException e) {
                    throw new RuntimeException("Exception while calling TrustManagerFactory.init()", e);
                }
                sslContextBuilder.trustManager(trustManagerFactory);
            }
            if (sslConfig.keyStorePath != null) {
                KeyManagerFactory keyManagerFactory;
                KeyStore keyStore = this.createKeyStore(sslConfig.keyStorePath, sslConfig.keyStorePassword);
                try {
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, sslConfig.keyStorePassword.toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Exception while creating KeyManagerFactory", e);
                }
                catch (KeyStoreException | UnrecoverableKeyException e) {
                    throw new RuntimeException("Exception while calling KeyManagerFactory.init()", e);
                }
                sslContextBuilder.keyManager(keyManagerFactory);
            }
            if (sslConfig.cipherSuites.size() > 0) {
                sslContextBuilder.ciphers(sslConfig.cipherSuites);
            }
            if (sslConfig.certPath != null && sslConfig.privateKeyPath != null) {
                try {
                    sslContextBuilder.keyManager(new BufferedInputStream(new FileInputStream(sslConfig.certPath)), new BufferedInputStream(new FileInputStream(sslConfig.privateKeyPath)));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(String.format("Invalid certificate or private key: %s", e.getMessage()));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Invalid certificate or private key file path", e);
                }
            } else if (sslConfig.certPath == null != (sslConfig.privateKeyPath == null)) {
                throw new RuntimeException(String.format("%s cannot be set without %s and vice-versa: %s is not set", "scylla.ssl.openssl.keyCertChain", "scylla.ssl.openssl.privateKey", sslConfig.certPath == null ? "scylla.ssl.openssl.keyCertChain" : "scylla.ssl.openssl.privateKey"));
            }
            try {
                context = sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            RemoteEndpointAwareNettySSLOptions sslOptions = new RemoteEndpointAwareNettySSLOptions(context);
            clusterBuilder.withSSL(sslOptions);
        }
        clusterBuilder = clusterBuilder.withProtocolVersion(ProtocolVersion.V4);
        String user = cqlConfiguration.user;
        String password = cqlConfiguration.password;
        if (user != null && password != null) {
            clusterBuilder = clusterBuilder.withCredentials(user, password);
        }
        switch (cqlConfiguration.getReplicaOrdering()) {
            case NEUTRAL: {
                replicaOrdering = TokenAwarePolicy.ReplicaOrdering.NEUTRAL;
                break;
            }
            case TOPOLOGICAL: {
                replicaOrdering = TokenAwarePolicy.ReplicaOrdering.TOPOLOGICAL;
                break;
            }
            default: {
                replicaOrdering = TokenAwarePolicy.ReplicaOrdering.RANDOM;
            }
        }
        if (cqlConfiguration.getLocalRackName() != null) {
            RackAwareRoundRobinPolicy.Builder builder = RackAwareRoundRobinPolicy.builder().withLocalRack(cqlConfiguration.getLocalRackName());
            if (cqlConfiguration.getLocalDCName() != null) {
                builder = builder.withLocalDc(cqlConfiguration.getLocalDCName());
            }
            clusterBuilder = clusterBuilder.withLoadBalancingPolicy(new TokenAwarePolicy((LoadBalancingPolicy)builder.build(), replicaOrdering));
        } else {
            clusterBuilder = cqlConfiguration.getLocalDCName() != null ? clusterBuilder.withLoadBalancingPolicy(new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(cqlConfiguration.getLocalDCName()).build(), replicaOrdering)) : clusterBuilder.withLoadBalancingPolicy(new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy(), replicaOrdering));
        }
        if (cqlConfiguration.queryOptionsFetchSize > 0) {
            QueryOptions queryOptions = new QueryOptions();
            queryOptions.setFetchSize(cqlConfiguration.queryOptionsFetchSize);
            clusterBuilder = clusterBuilder.withQueryOptions(queryOptions);
        }
        this.driverCluster = clusterBuilder.build();
        this.driverSession = this.driverCluster.connect();
        switch (cqlConfiguration.getConsistencyLevel()) {
            case ONE: {
                this.consistencyLevel = ConsistencyLevel.ONE;
                break;
            }
            case TWO: {
                this.consistencyLevel = ConsistencyLevel.TWO;
                break;
            }
            case THREE: {
                this.consistencyLevel = ConsistencyLevel.THREE;
                break;
            }
            case QUORUM: {
                this.consistencyLevel = ConsistencyLevel.QUORUM;
                break;
            }
            case ALL: {
                this.consistencyLevel = ConsistencyLevel.ALL;
                break;
            }
            case LOCAL_QUORUM: {
                this.consistencyLevel = ConsistencyLevel.LOCAL_QUORUM;
                break;
            }
            case LOCAL_ONE: {
                this.consistencyLevel = ConsistencyLevel.LOCAL_ONE;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported consistency level: " + String.valueOf((Object)cqlConfiguration.getConsistencyLevel()));
            }
        }
    }

    protected Session getDriverSession() {
        return this.driverSession;
    }

    protected ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public void close() {
        if (this.driverSession != null) {
            this.driverSession.close();
        }
        if (this.driverCluster != null) {
            this.driverCluster.close();
        }
    }

    private KeyStore createKeyStore(String path, String password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("JKS");
            try (InputStream inputStream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
                keyStore.load(inputStream, password.toCharArray());
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while reading keystore", e);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Exception while loading keystore", e);
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Exception while creating keystore", e);
        }
        return keyStore;
    }
}

