/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.cql.driver3;

import com.scylladb.cdc.cql.driver3.Driver3Field;
import com.scylladb.cdc.model.worker.ChangeSchema;
import com.scylladb.cdc.model.worker.cql.CqlDate;
import com.scylladb.cdc.model.worker.cql.CqlDuration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shaded.com.scylladb.cdc.driver3.driver.core.Duration;
import shaded.com.scylladb.cdc.driver3.driver.core.LocalDate;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleValue;
import shaded.com.scylladb.cdc.driver3.driver.core.UDTValue;

class Driver3ToLibraryTranslator {
    Driver3ToLibraryTranslator() {
    }

    public static Object translate(Object driverObject, ChangeSchema.DataType dataType) {
        if (driverObject == null) {
            return null;
        }
        if (driverObject instanceof List) {
            List driverList = (List)driverObject;
            ChangeSchema.DataType innerType = dataType.getTypeArguments().get(0);
            return driverList.stream().map(o -> Driver3ToLibraryTranslator.translate(o, innerType)).map(o -> new Driver3Field(innerType, o)).collect(Collectors.toList());
        }
        if (driverObject instanceof Set) {
            Set driverSet = (Set)driverObject;
            ChangeSchema.DataType innerType = dataType.getTypeArguments().get(0);
            return driverSet.stream().map(o -> Driver3ToLibraryTranslator.translate(o, innerType)).map(o -> new Driver3Field(innerType, o)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (driverObject instanceof Map) {
            Map driverMap = (Map)driverObject;
            ChangeSchema.DataType keyType = dataType.getTypeArguments().get(0);
            ChangeSchema.DataType valueType = dataType.getTypeArguments().get(1);
            LinkedHashMap<Driver3Field, Driver3Field> translatedMap = new LinkedHashMap<Driver3Field, Driver3Field>();
            for (Map.Entry entry : driverMap.entrySet()) {
                Driver3Field key = new Driver3Field(keyType, Driver3ToLibraryTranslator.translate(entry.getKey(), keyType));
                Driver3Field value = new Driver3Field(valueType, Driver3ToLibraryTranslator.translate(entry.getValue(), valueType));
                translatedMap.put(key, value);
            }
            return translatedMap;
        }
        if (driverObject instanceof UDTValue) {
            UDTValue driverUDT = (UDTValue)driverObject;
            LinkedHashMap<String, Driver3Field> translatedMap = new LinkedHashMap<String, Driver3Field>();
            for (Map.Entry<String, ChangeSchema.DataType> entry : dataType.getUdtType().getFields().entrySet()) {
                Object translatedObject = Driver3ToLibraryTranslator.translate(driverUDT.getObject(entry.getKey()), entry.getValue());
                Driver3Field field = new Driver3Field(entry.getValue(), translatedObject);
                translatedMap.put(entry.getKey(), field);
            }
            return translatedMap;
        }
        if (driverObject instanceof TupleValue) {
            TupleValue driverTuple = (TupleValue)driverObject;
            ArrayList<Driver3Field> translatedTuple = new ArrayList<Driver3Field>();
            int idx = 0;
            for (ChangeSchema.DataType fieldType : dataType.getTypeArguments()) {
                Object translatedObject = Driver3ToLibraryTranslator.translate(driverTuple.getObject(idx), fieldType);
                translatedTuple.add(new Driver3Field(fieldType, translatedObject));
                ++idx;
            }
            return translatedTuple;
        }
        if (driverObject instanceof Duration) {
            Duration driverDuration = (Duration)driverObject;
            return new CqlDuration(driverDuration.getMonths(), driverDuration.getDays(), driverDuration.getNanoseconds());
        }
        if (driverObject instanceof LocalDate) {
            LocalDate driverDate = (LocalDate)driverObject;
            return new CqlDate(driverDate.getYear(), driverDate.getMonth(), driverDate.getDay());
        }
        return driverObject;
    }
}

