/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.master;

import com.scylladb.cdc.model.GenerationId;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;

public final class GenerationMetadata {
    private final Timestamp start;
    private final Optional<Timestamp> end;
    private final SortedSet<StreamId> streams;

    public GenerationMetadata(Timestamp start, Optional<Timestamp> end, SortedSet<StreamId> streams) {
        this.start = Preconditions.checkNotNull(start);
        this.end = Preconditions.checkNotNull(end);
        this.streams = Preconditions.checkNotNull(streams);
        Preconditions.checkArgument(!streams.isEmpty());
    }

    public GenerationId getId() {
        return new GenerationId(this.start);
    }

    public boolean isClosed() {
        return this.end.isPresent();
    }

    public Timestamp getStart() {
        return this.start;
    }

    public Optional<Timestamp> getEnd() {
        return this.end;
    }

    public SortedSet<StreamId> getStreams() {
        return this.streams;
    }

    public Optional<GenerationId> getNextGenerationId() {
        return this.isClosed() ? Optional.of(new GenerationId(this.end.get())) : Optional.empty();
    }

    public GenerationMetadata withEnd(Timestamp end) {
        return new GenerationMetadata(this.start, Optional.of(end), this.streams);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenerationMetadata)) {
            return false;
        }
        GenerationMetadata o = (GenerationMetadata)other;
        return this.start.equals(o.start) && this.end.equals(o.end) && this.streams.equals(o.streams);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.streams);
    }

    public String toString() {
        return String.format("GenerationMetadata(%s, %s, %s)", this.start, this.end, this.streams);
    }
}

