/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;

public class ChangeSchema {
    private final List<ColumnDefinition> columnDefinitions;

    public ChangeSchema(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = Preconditions.checkNotNull(columnDefinitions);
    }

    public List<ColumnDefinition> getAllColumnDefinitions() {
        return this.columnDefinitions;
    }

    public List<ColumnDefinition> getCdcColumnDefinitions() {
        return this.columnDefinitions.stream().filter(ColumnDefinition::isCdcColumn).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public List<ColumnDefinition> getNonCdcColumnDefinitions() {
        return this.columnDefinitions.stream().filter(c -> !c.isCdcColumn()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public ColumnDefinition getColumnDefinition(int i) {
        return this.columnDefinitions.get(i);
    }

    public ColumnDefinition getColumnDefinition(String columnName) {
        Optional<ColumnDefinition> result = this.columnDefinitions.stream().filter(c -> c.getColumnName().equals(columnName)).findFirst();
        return result.orElseThrow(() -> new IllegalArgumentException("Column name " + columnName + " is not present in change schema."));
    }

    public ColumnDefinition getDeletedColumnDefinition(String columnName) {
        return this.getColumnDefinition("cdc$deleted_" + columnName);
    }

    public ColumnDefinition getDeletedColumnDefinition(ColumnDefinition columnDefinition) {
        return this.getDeletedColumnDefinition(columnDefinition.getColumnName());
    }

    public ColumnDefinition getDeletedElementsColumnDefinition(String columnName) {
        return this.getColumnDefinition("cdc$deleted_elements_" + columnName);
    }

    public ColumnDefinition getDeletedElementsColumnDefinition(ColumnDefinition columnDefinition) {
        return this.getDeletedElementsColumnDefinition(columnDefinition.getColumnName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSchema that = (ChangeSchema)o;
        return this.columnDefinitions.equals(that.columnDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.columnDefinitions);
    }

    public static final class ColumnDefinition {
        private final String columnName;
        private final int index;
        private final DataType cdcLogDataType;
        private final DataType baseTableDataType;
        private final ColumnKind baseTableColumnKind;

        public ColumnDefinition(String columnName, int index, DataType cdcLogDataType, DataType baseTableDataType, ColumnKind baseTableColumnKind) {
            this.columnName = columnName;
            this.index = index;
            this.cdcLogDataType = cdcLogDataType;
            this.baseTableDataType = baseTableDataType;
            this.baseTableColumnKind = baseTableColumnKind;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isCdcColumn() {
            return this.columnName.startsWith("cdc$");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public DataType getCdcLogDataType() {
            return this.cdcLogDataType;
        }

        public DataType getBaseTableDataType() {
            if (this.isCdcColumn()) {
                throw new IllegalStateException("Cannot get base table data type for CDC columns.");
            }
            return this.baseTableDataType;
        }

        @Deprecated
        public ColumnType getBaseTableColumnType() {
            switch (this.getBaseTableColumnKind()) {
                case REGULAR: {
                    return ColumnType.REGULAR;
                }
                case CLUSTERING_KEY: {
                    return ColumnType.CLUSTERING_KEY;
                }
                case PARTITION_KEY: {
                    return ColumnType.PARTITION_KEY;
                }
            }
            throw new IllegalStateException("Unknown column kind: " + String.valueOf((Object)this.getBaseTableColumnKind()));
        }

        public ColumnKind getBaseTableColumnKind() {
            if (this.isCdcColumn()) {
                throw new IllegalStateException("Cannot get base table column type for CDC columns.");
            }
            return this.baseTableColumnKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.baseTableColumnKind, this.baseTableDataType, this.cdcLogDataType, this.columnName, this.index});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColumnDefinition)) {
                return false;
            }
            ColumnDefinition other = (ColumnDefinition)obj;
            return this.baseTableColumnKind == other.baseTableColumnKind && Objects.equals(this.baseTableDataType, other.baseTableDataType) && Objects.equals(this.cdcLogDataType, other.cdcLogDataType) && Objects.equals(this.columnName, other.columnName) && this.index == other.index;
        }
    }

    public static enum ColumnKind {
        REGULAR,
        PARTITION_KEY,
        CLUSTERING_KEY;

    }

    @Deprecated
    public static enum ColumnType {
        REGULAR,
        PARTITION_KEY,
        CLUSTERING_KEY;

    }

    public static class DataType {
        private final CqlType cqlType;
        private final boolean frozen;
        private final List<DataType> typeArguments;
        private final UdtType udtType;

        public DataType(CqlType cqlType) {
            this(cqlType, null, null, false);
        }

        public DataType(CqlType cqlType, List<DataType> typeArguments, boolean frozen) {
            this(cqlType, typeArguments, null, frozen);
        }

        public DataType(CqlType cqlType, UdtType udtType, boolean frozen) {
            this(cqlType, null, udtType, frozen);
        }

        public DataType(CqlType cqlType, List<DataType> typeArguments, UdtType udtType, boolean frozen) {
            Preconditions.checkArgument(typeArguments == null || udtType == null, "Cannot have both non-null type arguments and UdtType.");
            this.cqlType = cqlType;
            this.typeArguments = typeArguments;
            this.udtType = udtType;
            this.frozen = frozen;
            boolean hasTypeArguments = typeArguments != null;
            boolean shouldHaveTypeArguments = cqlType == CqlType.MAP || cqlType == CqlType.LIST || cqlType == CqlType.SET || cqlType == CqlType.TUPLE;
            Preconditions.checkArgument(hasTypeArguments == shouldHaveTypeArguments, "Unexpected value of type arguments for this CQL type: " + cqlType.name());
            boolean hasUdtType = udtType != null;
            boolean shouldHaveUdtType = cqlType == CqlType.UDT;
            Preconditions.checkArgument(hasUdtType == shouldHaveUdtType, "Unexpected value of UdtType for this CQL type: " + cqlType.name());
        }

        public DataType(DataType dataType, boolean isFrozen) {
            this(dataType.cqlType, dataType.typeArguments, dataType.udtType, isFrozen);
        }

        public static DataType list(DataType valueType) {
            return DataType.list(valueType, false);
        }

        public static DataType list(DataType valueType, boolean frozen) {
            return new DataType(CqlType.LIST, ImmutableList.of(valueType), frozen);
        }

        public CqlType getCqlType() {
            return this.cqlType;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public boolean isAtomic() {
            return this.isNative() || this.isFrozen();
        }

        public boolean isNative() {
            return this.cqlType.compareTo(CqlType.LIST) < 0;
        }

        public List<DataType> getTypeArguments() {
            if (this.typeArguments == null) {
                throw new IllegalStateException("Cannot get type arguments for this CQL type: " + this.cqlType.name());
            }
            return this.typeArguments;
        }

        public UdtType getUdtType() {
            if (this.udtType == null) {
                throw new IllegalStateException("Cannot get UdtType for this CQL type: " + this.cqlType.name());
            }
            return this.udtType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataType dataType = (DataType)o;
            return this.cqlType == dataType.cqlType && this.frozen == dataType.frozen && Objects.equals(this.typeArguments, dataType.typeArguments) && Objects.equals(this.udtType, dataType.udtType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.cqlType, this.frozen, this.typeArguments, this.udtType});
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.frozen) {
                result.append("FROZEN<");
            }
            result.append(this.cqlType.name());
            if (this.typeArguments != null) {
                result.append('<');
                result.append(this.typeArguments.stream().map(DataType::toString).collect(Collectors.joining(", ")));
                result.append('>');
            }
            if (this.udtType != null) {
                result.append('(').append(this.udtType.keyspace).append('.').append(this.udtType.name).append(')');
                result.append('{');
                result.append(this.udtType.getFields().entrySet().stream().map(e -> (String)e.getKey() + " " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")));
                result.append('}');
            }
            if (this.frozen) {
                result.append('>');
            }
            return result.toString();
        }

        public static class UdtType {
            private final Map<String, DataType> fields;
            private final String keyspace;
            private final String name;

            public UdtType(Map<String, DataType> fields, String keyspace, String name) {
                this.fields = fields;
                this.keyspace = keyspace;
                this.name = name;
            }

            public Map<String, DataType> getFields() {
                return this.fields;
            }

            public String getKeyspace() {
                return this.keyspace;
            }

            public String getName() {
                return this.name;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UdtType udtType = (UdtType)o;
                return this.fields.equals(udtType.fields) && this.keyspace.equals(udtType.keyspace) && this.name.equals(udtType.name);
            }

            public int hashCode() {
                return Objects.hash(this.fields, this.keyspace, this.name);
            }
        }
    }

    public static enum CqlType {
        ASCII,
        BIGINT,
        BLOB,
        BOOLEAN,
        COUNTER,
        DECIMAL,
        DOUBLE,
        FLOAT,
        INT,
        TEXT,
        TIMESTAMP,
        UUID,
        VARCHAR,
        VARINT,
        TIMEUUID,
        INET,
        DATE,
        TIME,
        SMALLINT,
        TINYINT,
        DURATION,
        LIST,
        MAP,
        SET,
        UDT,
        TUPLE;

    }
}

