/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.scylladb.cdc.model.worker.ConsumerDispatch;
import com.scylladb.cdc.model.worker.RawChange;
import com.scylladb.cdc.model.worker.RawChangeConsumer;
import com.scylladb.cdc.model.worker.Task;
import com.scylladb.cdc.model.worker.TaskAndRawChangeConsumer;
import com.scylladb.cdc.model.worker.TaskState;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class Consumer {
    private final ConsumerDispatch consumerDispatch;

    private Consumer(ConsumerDispatch consumerDispatch) {
        this.consumerDispatch = consumerDispatch;
    }

    public Consumer(final RawChangeConsumer rawChangeConsumer) {
        this(new TaskAndRawChangeConsumer(){

            @Override
            public CompletableFuture<Void> consume(Task task, RawChange change) {
                return rawChangeConsumer.consume(change);
            }
        });
    }

    public Consumer(final TaskAndRawChangeConsumer taskAndRawChangeConsumer) {
        this(new ConsumerDispatch(){

            @Override
            public CompletableFuture<TaskState> consume(Task task, RawChange change, Task nextTask) {
                return taskAndRawChangeConsumer.consume(task, change).thenCompose(v -> CompletableFuture.completedFuture(nextTask.state));
            }
        });
    }

    public static Consumer forTaskAndRawChangeConsumer(TaskAndRawChangeConsumer c) {
        return new Consumer(c);
    }

    public static Consumer syncTaskAndRawChangeConsumer(final BiConsumer<Task, RawChange> c) {
        return new Consumer(new TaskAndRawChangeConsumer(){

            @Override
            public CompletableFuture<Void> consume(Task task, RawChange change) {
                c.accept(task, change);
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    public static Consumer forRawChangeConsumer(RawChangeConsumer c) {
        return new Consumer(c);
    }

    public static Consumer syncRawChangeConsumer(final java.util.function.Consumer<RawChange> c) {
        return new Consumer(new RawChangeConsumer(){

            @Override
            public CompletableFuture<Void> consume(RawChange change) {
                c.accept(change);
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    ConsumerDispatch getConsumerDispatch() {
        return this.consumerDispatch;
    }
}

