/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.worker.ChangeId;
import com.scylladb.cdc.model.worker.TaskState;
import java.util.Objects;
import java.util.SortedSet;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;

public final class Task {
    public final TaskId id;
    public final SortedSet<StreamId> streams;
    public final TaskState state;

    public Task(TaskId id, SortedSet<StreamId> streams, TaskState state) {
        this.id = Preconditions.checkNotNull(id);
        this.streams = Preconditions.checkNotNull(streams);
        this.state = Preconditions.checkNotNull(state);
    }

    public Task updateState(TaskState newState) {
        Preconditions.checkNotNull(newState);
        return new Task(this.id, this.streams, newState);
    }

    public Task updateState(ChangeId lastSeenChangeId) {
        Preconditions.checkNotNull(lastSeenChangeId);
        return new Task(this.id, this.streams, this.state.update(lastSeenChangeId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task task = (Task)o;
        return this.id.equals(task.id) && this.streams.equals(task.streams) && this.state.equals(task.state);
    }

    public String toString() {
        return String.format("Task(%s, %s, %s)", this.id, this.streams, this.state);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.streams, this.state);
    }
}

