/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker;

import com.scylladb.cdc.cql.WorkerCQL;
import com.scylladb.cdc.model.ExponentialRetryBackoffWithJitter;
import com.scylladb.cdc.model.RetryBackoff;
import com.scylladb.cdc.model.worker.Consumer;
import com.scylladb.cdc.model.worker.RawChangeConsumer;
import com.scylladb.cdc.model.worker.TaskAndRawChangeConsumer;
import com.scylladb.cdc.transport.WorkerTransport;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;

public final class WorkerConfiguration {
    public static final long DEFAULT_QUERY_TIME_WINDOW_SIZE_MS = 30000L;
    public static final long DEFAULT_CONFIDENCE_WINDOW_SIZE_MS = 30000L;
    public static final long DEFAULT_MINIMAL_WAIT_FOR_WINDOW_MS = 0L;
    public static final RetryBackoff DEFAULT_WORKER_RETRY_BACKOFF = new ExponentialRetryBackoffWithJitter(50, 30000, 0.2);
    public final WorkerTransport transport;
    public final WorkerCQL cql;
    public final Consumer consumer;
    public final long queryTimeWindowSizeMs;
    public final long confidenceWindowSizeMs;
    public final long minimalWaitForWindowMs;
    public final RetryBackoff workerRetryBackoff;
    private final ScheduledExecutorService executorService;
    private final Clock clock;

    private WorkerConfiguration(WorkerTransport transport, WorkerCQL cql, Consumer consumer, long queryTimeWindowSizeMs, long confidenceWindowSizeMs, RetryBackoff workerRetryBackoff, ScheduledExecutorService executorService, Clock clock, long minimalWaitForWindowMs) {
        this.transport = Preconditions.checkNotNull(transport);
        this.cql = Preconditions.checkNotNull(cql);
        this.consumer = Preconditions.checkNotNull(consumer);
        Preconditions.checkArgument(queryTimeWindowSizeMs > 0L);
        this.queryTimeWindowSizeMs = queryTimeWindowSizeMs;
        Preconditions.checkArgument(confidenceWindowSizeMs > 0L);
        this.confidenceWindowSizeMs = confidenceWindowSizeMs;
        this.workerRetryBackoff = Preconditions.checkNotNull(workerRetryBackoff);
        this.executorService = executorService;
        this.clock = Preconditions.checkNotNull(clock);
        this.minimalWaitForWindowMs = minimalWaitForWindowMs;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WorkerTransport transport;
        private WorkerCQL cql;
        private Consumer consumer;
        private ScheduledExecutorService executorService;
        private long queryTimeWindowSizeMs = 30000L;
        private long confidenceWindowSizeMs = 30000L;
        private long minimalWaitForWindowMs = 0L;
        private RetryBackoff workerRetryBackoff = DEFAULT_WORKER_RETRY_BACKOFF;
        private Clock clock = Clock.systemDefaultZone();

        public Builder withTransport(WorkerTransport transport) {
            this.transport = Preconditions.checkNotNull(transport);
            return this;
        }

        public Builder withCQL(WorkerCQL cql) {
            this.cql = Preconditions.checkNotNull(cql);
            return this;
        }

        public Builder withConsumer(Consumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder withConsumer(TaskAndRawChangeConsumer consumer) {
            return this.withTaskAndRawChangeConsumer(consumer);
        }

        public Builder withTaskAndRawChangeConsumer(TaskAndRawChangeConsumer consumer) {
            return this.withConsumer(Consumer.forTaskAndRawChangeConsumer(Preconditions.checkNotNull(consumer)));
        }

        public Builder withConsumer(RawChangeConsumer consumer) {
            return this.withRawChangeConsumer(consumer);
        }

        public Builder withRawChangeConsumer(RawChangeConsumer consumer) {
            return this.withConsumer(Consumer.forRawChangeConsumer(Preconditions.checkNotNull(consumer)));
        }

        public Builder withQueryTimeWindowSizeMs(long queryTimeWindowSizeMs) {
            Preconditions.checkArgument(queryTimeWindowSizeMs > 0L);
            this.queryTimeWindowSizeMs = queryTimeWindowSizeMs;
            return this;
        }

        public Builder withConfidenceWindowSizeMs(long confidenceWindowSizeMs) {
            Preconditions.checkArgument(confidenceWindowSizeMs > 0L);
            this.confidenceWindowSizeMs = confidenceWindowSizeMs;
            return this;
        }

        public Builder withWorkerRetryBackoff(RetryBackoff workerRetryBackoff) {
            this.workerRetryBackoff = Preconditions.checkNotNull(workerRetryBackoff);
            return this;
        }

        public Builder withExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        public Builder withMinimalWaitForWindowMs(long minimalWaitForWindowMs) {
            Preconditions.checkArgument(minimalWaitForWindowMs >= 0L);
            this.minimalWaitForWindowMs = minimalWaitForWindowMs;
            return this;
        }

        public WorkerConfiguration build() {
            if (this.executorService == null) {
                this.executorService = Executors.newScheduledThreadPool(1);
            }
            return new WorkerConfiguration(this.transport, this.cql, this.consumer, this.queryTimeWindowSizeMs, this.confidenceWindowSizeMs, this.workerRetryBackoff, this.executorService, this.clock, this.minimalWaitForWindowMs);
        }
    }
}

