/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.model.worker.cql;

import java.util.Objects;

public class CqlDuration {
    private final long months;
    private final long days;
    private final long nanoseconds;

    public CqlDuration(long months, long days, long nanoseconds) {
        this.months = months;
        this.days = days;
        this.nanoseconds = nanoseconds;
    }

    public long getMonths() {
        return this.months;
    }

    public long getDays() {
        return this.days;
    }

    public long getNanoseconds() {
        return this.nanoseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CqlDuration cqlDuration = (CqlDuration)o;
        return this.months == cqlDuration.months && this.days == cqlDuration.days && this.nanoseconds == cqlDuration.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.nanoseconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.months < 0L || this.days < 0L || this.nanoseconds < 0L) {
            sb.append('-');
        }
        long monthRemainder = this.appendUnit(sb, Math.abs(this.months), 12L, "y");
        this.appendUnit(sb, monthRemainder, 1L, "mo");
        this.appendUnit(sb, Math.abs(this.days), 1L, "d");
        long nanosecondRemainder = this.appendUnit(sb, Math.abs(this.nanoseconds), 3600000000000L, "h");
        nanosecondRemainder = this.appendUnit(sb, nanosecondRemainder, 60000000000L, "m");
        nanosecondRemainder = this.appendUnit(sb, nanosecondRemainder, 1000000000L, "s");
        nanosecondRemainder = this.appendUnit(sb, nanosecondRemainder, 1000000L, "ms");
        nanosecondRemainder = this.appendUnit(sb, nanosecondRemainder, 1000L, "us");
        this.appendUnit(sb, nanosecondRemainder, 1L, "ns");
        return sb.toString();
    }

    private long appendUnit(StringBuilder sb, long count, long unitFactor, String unitName) {
        if (count == 0L || count < unitFactor) {
            return count;
        }
        sb.append(count / unitFactor).append(unitName);
        return count % unitFactor;
    }
}

