/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.channel;

import java.lang.reflect.Constructor;
import shaded.com.scylladb.cdc.driver3.channel.Channel;
import shaded.com.scylladb.cdc.driver3.channel.ChannelException;
import shaded.com.scylladb.cdc.driver3.channel.ChannelFactory;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;
import shaded.com.scylladb.cdc.driver3.util.internal.StringUtil;

public class ReflectiveChannelFactory<T extends Channel>
implements ChannelFactory<T> {
    private final Constructor<? extends T> constructor;

    public ReflectiveChannelFactory(Class<? extends T> clazz) {
        ObjectUtil.checkNotNull(clazz, "clazz");
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + StringUtil.simpleClassName(clazz) + " does not have a public non-arg constructor", e);
        }
    }

    @Override
    public T newChannel() {
        try {
            return (T)((Channel)this.constructor.newInstance(new Object[0]));
        }
        catch (Throwable t2) {
            throw new ChannelException("Unable to create Channel from class " + this.constructor.getDeclaringClass(), t2);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(ReflectiveChannelFactory.class) + '(' + StringUtil.simpleClassName(this.constructor.getDeclaringClass()) + ".class)";
    }
}

