/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.cache;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtIncompatible;
import shaded.com.scylladb.cdc.driver3.common.cache.AbstractCache;
import shaded.com.scylladb.cdc.driver3.common.cache.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.cache.LoadingCache;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.common.collect.Maps;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.UncheckedExecutionException;
import shaded.com.scylladb.cdc.driver3.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

