/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtCompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtIncompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.J2ktIncompatible;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.AbstractBiMap;
import shaded.com.scylladb.cdc.driver3.common.collect.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.collect.EnumBiMap;
import shaded.com.scylladb.cdc.driver3.common.collect.ParametricNullness;
import shaded.com.scylladb.cdc.driver3.common.collect.Serialization;
import shaded.com.scylladb.cdc.driver3.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
@J2ktIncompatible
public final class EnumHashBiMap<K extends Enum<K>, V>
extends AbstractBiMap<K, V> {
    transient Class<K> keyTypeOrObjectUnderJ2cl;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Class<K> keyType) {
        return new EnumHashBiMap<K, V>(keyType);
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Map<K, ? extends V> map) {
        EnumHashBiMap<K, V> bimap = EnumHashBiMap.create(EnumBiMap.inferKeyTypeOrObjectUnderJ2cl(map));
        bimap.putAll((Map)map);
        return bimap;
    }

    private EnumHashBiMap(Class<K> keyType) {
        super(new EnumMap(keyType), new HashMap());
        this.keyTypeOrObjectUnderJ2cl = keyType;
    }

    @Override
    K checkKey(K key) {
        return (K)((Enum)Preconditions.checkNotNull(key));
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(K key, @ParametricNullness V value) {
        return super.put(key, value);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(K key, @ParametricNullness V value) {
        return super.forcePut(key, value);
    }

    @GwtIncompatible
    public Class<K> keyType() {
        return this.keyTypeOrObjectUnderJ2cl;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.keyTypeOrObjectUnderJ2cl);
        Serialization.writeMap(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyTypeOrObjectUnderJ2cl = (Class)Objects.requireNonNull(stream.readObject());
        this.setDelegates(new EnumMap(this.keyTypeOrObjectUnderJ2cl), new HashMap());
        Serialization.populateMap(this, stream);
    }
}

