/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.collect;

import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtCompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtIncompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.J2ktIncompatible;
import shaded.com.scylladb.cdc.driver3.common.collect.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableAsList;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableCollection;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.common.collect.UnmodifiableListIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    @CheckForNull
    Object[] internalArray() {
        return this.delegateList.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.delegateList.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.delegateList.internalArrayEnd();
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

