/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.collect;

import java.util.Collections;
import java.util.Spliterator;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtCompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtIncompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.J2ktIncompatible;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.common.collect.Iterators;
import shaded.com.scylladb.cdc.driver3.common.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

