/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.collect;

import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtCompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.GwtIncompatible;
import shaded.com.scylladb.cdc.driver3.common.annotations.J2ktIncompatible;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableSet;
import shaded.com.scylladb.cdc.driver3.common.collect.Iterators;
import shaded.com.scylladb.cdc.driver3.common.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

