/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.graph;

import shaded.com.scylladb.cdc.driver3.common.annotations.Beta;
import shaded.com.scylladb.cdc.driver3.common.base.Function;
import shaded.com.scylladb.cdc.driver3.common.base.Functions;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.common.collect.Maps;
import shaded.com.scylladb.cdc.driver3.common.graph.BaseGraph;
import shaded.com.scylladb.cdc.driver3.common.graph.DirectedGraphConnections;
import shaded.com.scylladb.cdc.driver3.common.graph.ElementOrder;
import shaded.com.scylladb.cdc.driver3.common.graph.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.graph.EndpointPair;
import shaded.com.scylladb.cdc.driver3.common.graph.ForwardingGraph;
import shaded.com.scylladb.cdc.driver3.common.graph.Graph;
import shaded.com.scylladb.cdc.driver3.common.graph.GraphBuilder;
import shaded.com.scylladb.cdc.driver3.common.graph.GraphConnections;
import shaded.com.scylladb.cdc.driver3.common.graph.GraphConstants;
import shaded.com.scylladb.cdc.driver3.common.graph.MutableGraph;
import shaded.com.scylladb.cdc.driver3.common.graph.StandardValueGraph;
import shaded.com.scylladb.cdc.driver3.common.graph.UndirectedGraphConnections;
import shaded.com.scylladb.cdc.driver3.errorprone.annotations.CanIgnoreReturnValue;
import shaded.com.scylladb.cdc.driver3.errorprone.annotations.Immutable;

@Immutable(containerOf={"N"})
@ElementTypesAreNonnullByDefault
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new StandardValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.buildOrThrow();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(node, graph.incidentEdges(node), edgeValueFn) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

